/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat;

import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;

public final class StatUtils {
    private static final UnivariateStatistic SUM = new Sum();
    private static final UnivariateStatistic SUM_OF_SQUARES = new SumOfSquares();
    private static final UnivariateStatistic PRODUCT = new Product();
    private static final UnivariateStatistic SUM_OF_LOGS = new SumOfLogs();
    private static final UnivariateStatistic MIN = new Min();
    private static final UnivariateStatistic MAX = new Max();
    private static final UnivariateStatistic MEAN = new Mean();
    private static final Variance VARIANCE = new Variance();
    private static final Percentile PERCENTILE = new Percentile();
    private static final GeometricMean GEOMETRIC_MEAN = new GeometricMean();

    private StatUtils() {
    }

    public static double sum(double[] dArray) {
        return SUM.evaluate(dArray);
    }

    public static double sum(double[] dArray, int n, int n2) {
        return SUM.evaluate(dArray, n, n2);
    }

    public static double sumSq(double[] dArray) {
        return SUM_OF_SQUARES.evaluate(dArray);
    }

    public static double sumSq(double[] dArray, int n, int n2) {
        return SUM_OF_SQUARES.evaluate(dArray, n, n2);
    }

    public static double product(double[] dArray) {
        return PRODUCT.evaluate(dArray);
    }

    public static double product(double[] dArray, int n, int n2) {
        return PRODUCT.evaluate(dArray, n, n2);
    }

    public static double sumLog(double[] dArray) {
        return SUM_OF_LOGS.evaluate(dArray);
    }

    public static double sumLog(double[] dArray, int n, int n2) {
        return SUM_OF_LOGS.evaluate(dArray, n, n2);
    }

    public static double mean(double[] dArray) {
        return MEAN.evaluate(dArray);
    }

    public static double mean(double[] dArray, int n, int n2) {
        return MEAN.evaluate(dArray, n, n2);
    }

    public static double geometricMean(double[] dArray) {
        return GEOMETRIC_MEAN.evaluate(dArray);
    }

    public static double geometricMean(double[] dArray, int n, int n2) {
        return GEOMETRIC_MEAN.evaluate(dArray, n, n2);
    }

    public static double variance(double[] dArray) {
        return VARIANCE.evaluate(dArray);
    }

    public static double variance(double[] dArray, int n, int n2) {
        return VARIANCE.evaluate(dArray, n, n2);
    }

    public static double variance(double[] dArray, double d, int n, int n2) {
        return VARIANCE.evaluate(dArray, d, n, n2);
    }

    public static double variance(double[] dArray, double d) {
        return VARIANCE.evaluate(dArray, d);
    }

    public static double populationVariance(double[] dArray) {
        return new Variance(false).evaluate(dArray);
    }

    public static double populationVariance(double[] dArray, int n, int n2) {
        return new Variance(false).evaluate(dArray, n, n2);
    }

    public static double populationVariance(double[] dArray, double d, int n, int n2) {
        return new Variance(false).evaluate(dArray, d, n, n2);
    }

    public static double populationVariance(double[] dArray, double d) {
        return new Variance(false).evaluate(dArray, d);
    }

    public static double max(double[] dArray) {
        return MAX.evaluate(dArray);
    }

    public static double max(double[] dArray, int n, int n2) {
        return MAX.evaluate(dArray, n, n2);
    }

    public static double min(double[] dArray) {
        return MIN.evaluate(dArray);
    }

    public static double min(double[] dArray, int n, int n2) {
        return MIN.evaluate(dArray, n, n2);
    }

    public static double percentile(double[] dArray, double d) {
        return PERCENTILE.evaluate(dArray, d);
    }

    public static double percentile(double[] dArray, int n, int n2, double d) {
        return PERCENTILE.evaluate(dArray, n, n2, d);
    }

    public static double sumDifference(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        if (n <= 0) {
            throw new NoDataException(LocalizedFormats.INSUFFICIENT_DIMENSION);
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] - dArray2[i];
        }
        return d;
    }

    public static double meanDifference(double[] dArray, double[] dArray2) {
        return StatUtils.sumDifference(dArray, dArray2) / (double)dArray.length;
    }

    public static double varianceDifference(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        for (int i = 0; i < n; ++i) {
            d4 = dArray[i] - dArray2[i];
            d2 += (d4 - d) * (d4 - d);
            d3 += d4 - d;
        }
        return (d2 - d3 * d3 / (double)n) / (double)(n - 1);
    }

    public static double[] normalize(double[] dArray) {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        for (int i = 0; i < dArray.length; ++i) {
            descriptiveStatistics.addValue(dArray[i]);
        }
        double d = descriptiveStatistics.getMean();
        double d2 = descriptiveStatistics.getStandardDeviation();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = (dArray[i] - d) / d2;
        }
        return dArray2;
    }

    public static double[] mode(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return StatUtils.getMode(dArray, 0, dArray.length);
    }

    public static double[] mode(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        return StatUtils.getMode(dArray, n, n2);
    }

    private static double[] getMode(double[] dArray, int n, int n2) {
        Frequency frequency = new Frequency();
        for (int i = n; i < n + n2; ++i) {
            double d = dArray[i];
            if (Double.isNaN(d)) continue;
            frequency.addValue(Double.valueOf(d));
        }
        List<Comparable<?>> list = frequency.getMode();
        double[] dArray2 = new double[list.size()];
        int n3 = 0;
        for (Comparable<?> comparable : list) {
            dArray2[n3++] = (Double)comparable;
        }
        return dArray2;
    }
}

