/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public abstract class AbstractStorelessUnivariateStatistic
extends AbstractUnivariateStatistic
implements StorelessUnivariateStatistic {
    public double evaluate(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(dArray, 0, dArray.length);
    }

    public double evaluate(double[] dArray, int n, int n2) {
        if (this.test(dArray, n, n2)) {
            this.clear();
            this.incrementAll(dArray, n, n2);
        }
        return this.getResult();
    }

    public abstract StorelessUnivariateStatistic copy();

    public abstract void clear();

    public abstract double getResult();

    public abstract void increment(double var1);

    public void incrementAll(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        this.incrementAll(dArray, 0, dArray.length);
    }

    public void incrementAll(double[] dArray, int n, int n2) {
        if (this.test(dArray, n, n2)) {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.increment(dArray[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractStorelessUnivariateStatistic)) {
            return false;
        }
        AbstractStorelessUnivariateStatistic abstractStorelessUnivariateStatistic = (AbstractStorelessUnivariateStatistic)object;
        return Precision.equalsIncludingNaN(abstractStorelessUnivariateStatistic.getResult(), this.getResult()) && Precision.equalsIncludingNaN(abstractStorelessUnivariateStatistic.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

