/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateSummaryStatistics
implements StatisticalSummary,
Serializable {
    private static final long serialVersionUID = -8207112444016386906L;
    private final SummaryStatistics statisticsPrototype;
    private final SummaryStatistics statistics;

    public AggregateSummaryStatistics() {
        this(new SummaryStatistics());
    }

    public AggregateSummaryStatistics(SummaryStatistics summaryStatistics) {
        this(summaryStatistics, summaryStatistics == null ? null : new SummaryStatistics(summaryStatistics));
    }

    public AggregateSummaryStatistics(SummaryStatistics summaryStatistics, SummaryStatistics summaryStatistics2) {
        this.statisticsPrototype = summaryStatistics == null ? new SummaryStatistics() : summaryStatistics;
        this.statistics = summaryStatistics2 == null ? new SummaryStatistics() : summaryStatistics2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMax() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getMax();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMean() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getMean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMin() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getMin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getN() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStandardDeviation() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getStandardDeviation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSum() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getSum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getVariance() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getVariance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumOfLogs() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getSumOfLogs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getGeometricMean() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getGeometricMean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumsq() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getSumsq();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSecondMoment() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return this.statistics.getSecondMoment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalSummary getSummary() {
        SummaryStatistics summaryStatistics = this.statistics;
        synchronized (summaryStatistics) {
            return new StatisticalSummaryValues(this.getMean(), this.getVariance(), this.getN(), this.getMax(), this.getMin(), this.getSum());
        }
    }

    public SummaryStatistics createContributingStatistics() {
        AggregatingSummaryStatistics aggregatingSummaryStatistics = new AggregatingSummaryStatistics(this.statistics);
        SummaryStatistics.copy(this.statisticsPrototype, aggregatingSummaryStatistics);
        return aggregatingSummaryStatistics;
    }

    public static StatisticalSummaryValues aggregate(Collection<? extends StatisticalSummary> collection) {
        double d;
        if (collection == null) {
            return null;
        }
        Iterator<? extends StatisticalSummary> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        StatisticalSummary statisticalSummary = iterator.next();
        long l = statisticalSummary.getN();
        double d2 = statisticalSummary.getMin();
        double d3 = statisticalSummary.getSum();
        double d4 = statisticalSummary.getMax();
        double d5 = statisticalSummary.getVariance();
        double d6 = d5 * ((double)l - 1.0);
        double d7 = statisticalSummary.getMean();
        while (iterator.hasNext()) {
            statisticalSummary = iterator.next();
            if (statisticalSummary.getMin() < d2 || Double.isNaN(d2)) {
                d2 = statisticalSummary.getMin();
            }
            if (statisticalSummary.getMax() > d4 || Double.isNaN(d4)) {
                d4 = statisticalSummary.getMax();
            }
            d = l;
            double d8 = statisticalSummary.getN();
            l = (long)((double)l + d8);
            double d9 = statisticalSummary.getMean() - d7;
            d7 = (d3 += statisticalSummary.getSum()) / (double)l;
            double d10 = statisticalSummary.getVariance() * (d8 - 1.0);
            d6 = d6 + d10 + d9 * d9 * d * d8 / (double)l;
        }
        d = l == 0L ? Double.NaN : (l == 1L ? 0.0 : d6 / (double)(l - 1L));
        return new StatisticalSummaryValues(d7, d, l, d4, d2, d3);
    }

    private static class AggregatingSummaryStatistics
    extends SummaryStatistics {
        private static final long serialVersionUID = 1L;
        private final SummaryStatistics aggregateStatistics;

        AggregatingSummaryStatistics(SummaryStatistics summaryStatistics) {
            this.aggregateStatistics = summaryStatistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValue(double d) {
            super.addValue(d);
            SummaryStatistics summaryStatistics = this.aggregateStatistics;
            synchronized (summaryStatistics) {
                this.aggregateStatistics.addValue(d);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AggregatingSummaryStatistics)) {
                return false;
            }
            AggregatingSummaryStatistics aggregatingSummaryStatistics = (AggregatingSummaryStatistics)object;
            return super.equals(aggregatingSummaryStatistics) && this.aggregateStatistics.equals(aggregatingSummaryStatistics.aggregateStatistics);
        }

        public int hashCode() {
            return 123 + super.hashCode() + this.aggregateStatistics.hashCode();
        }
    }
}

