/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.StatisticalMultivariateSummary;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.VectorialCovariance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public class MultivariateSummaryStatistics
implements StatisticalMultivariateSummary,
Serializable {
    private static final long serialVersionUID = 2271900808994826718L;
    private int k;
    private long n = 0L;
    private StorelessUnivariateStatistic[] sumImpl;
    private StorelessUnivariateStatistic[] sumSqImpl;
    private StorelessUnivariateStatistic[] minImpl;
    private StorelessUnivariateStatistic[] maxImpl;
    private StorelessUnivariateStatistic[] sumLogImpl;
    private StorelessUnivariateStatistic[] geoMeanImpl;
    private StorelessUnivariateStatistic[] meanImpl;
    private VectorialCovariance covarianceImpl;

    public MultivariateSummaryStatistics(int n, boolean bl) {
        this.k = n;
        this.sumImpl = new StorelessUnivariateStatistic[n];
        this.sumSqImpl = new StorelessUnivariateStatistic[n];
        this.minImpl = new StorelessUnivariateStatistic[n];
        this.maxImpl = new StorelessUnivariateStatistic[n];
        this.sumLogImpl = new StorelessUnivariateStatistic[n];
        this.geoMeanImpl = new StorelessUnivariateStatistic[n];
        this.meanImpl = new StorelessUnivariateStatistic[n];
        for (int i = 0; i < n; ++i) {
            this.sumImpl[i] = new Sum();
            this.sumSqImpl[i] = new SumOfSquares();
            this.minImpl[i] = new Min();
            this.maxImpl[i] = new Max();
            this.sumLogImpl[i] = new SumOfLogs();
            this.geoMeanImpl[i] = new GeometricMean();
            this.meanImpl[i] = new Mean();
        }
        this.covarianceImpl = new VectorialCovariance(n, bl);
    }

    public void addValue(double[] dArray) {
        this.checkDimension(dArray.length);
        for (int i = 0; i < this.k; ++i) {
            double d = dArray[i];
            this.sumImpl[i].increment(d);
            this.sumSqImpl[i].increment(d);
            this.minImpl[i].increment(d);
            this.maxImpl[i].increment(d);
            this.sumLogImpl[i].increment(d);
            this.geoMeanImpl[i].increment(d);
            this.meanImpl[i].increment(d);
        }
        this.covarianceImpl.increment(dArray);
        ++this.n;
    }

    public int getDimension() {
        return this.k;
    }

    public long getN() {
        return this.n;
    }

    private double[] getResults(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        double[] dArray = new double[storelessUnivariateStatisticArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = storelessUnivariateStatisticArray[i].getResult();
        }
        return dArray;
    }

    public double[] getSum() {
        return this.getResults(this.sumImpl);
    }

    public double[] getSumSq() {
        return this.getResults(this.sumSqImpl);
    }

    public double[] getSumLog() {
        return this.getResults(this.sumLogImpl);
    }

    public double[] getMean() {
        return this.getResults(this.meanImpl);
    }

    public double[] getStandardDeviation() {
        double[] dArray = new double[this.k];
        if (this.getN() < 1L) {
            Arrays.fill(dArray, Double.NaN);
        } else if (this.getN() < 2L) {
            Arrays.fill(dArray, 0.0);
        } else {
            RealMatrix realMatrix = this.covarianceImpl.getResult();
            for (int i = 0; i < this.k; ++i) {
                dArray[i] = FastMath.sqrt(realMatrix.getEntry(i, i));
            }
        }
        return dArray;
    }

    public RealMatrix getCovariance() {
        return this.covarianceImpl.getResult();
    }

    public double[] getMax() {
        return this.getResults(this.maxImpl);
    }

    public double[] getMin() {
        return this.getResults(this.minImpl);
    }

    public double[] getGeometricMean() {
        return this.getResults(this.geoMeanImpl);
    }

    public String toString() {
        String string = ", ";
        String string2 = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultivariateSummaryStatistics:" + string2);
        stringBuilder.append("n: " + this.getN() + string2);
        this.append(stringBuilder, this.getMin(), "min: ", ", ", string2);
        this.append(stringBuilder, this.getMax(), "max: ", ", ", string2);
        this.append(stringBuilder, this.getMean(), "mean: ", ", ", string2);
        this.append(stringBuilder, this.getGeometricMean(), "geometric mean: ", ", ", string2);
        this.append(stringBuilder, this.getSumSq(), "sum of squares: ", ", ", string2);
        this.append(stringBuilder, this.getSumLog(), "sum of logarithms: ", ", ", string2);
        this.append(stringBuilder, this.getStandardDeviation(), "standard deviation: ", ", ", string2);
        stringBuilder.append("covariance: " + this.getCovariance().toString() + string2);
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, double[] dArray, String string, String string2, String string3) {
        stringBuilder.append(string);
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(dArray[i]);
        }
        stringBuilder.append(string3);
    }

    public void clear() {
        this.n = 0L;
        for (int i = 0; i < this.k; ++i) {
            this.minImpl[i].clear();
            this.maxImpl[i].clear();
            this.sumImpl[i].clear();
            this.sumLogImpl[i].clear();
            this.sumSqImpl[i].clear();
            this.geoMeanImpl[i].clear();
            this.meanImpl[i].clear();
        }
        this.covarianceImpl.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultivariateSummaryStatistics)) {
            return false;
        }
        MultivariateSummaryStatistics multivariateSummaryStatistics = (MultivariateSummaryStatistics)object;
        return MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getGeometricMean(), this.getGeometricMean()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getMax(), this.getMax()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getMean(), this.getMean()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getMin(), this.getMin()) && Precision.equalsIncludingNaN(multivariateSummaryStatistics.getN(), this.getN()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getSum(), this.getSum()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getSumSq(), this.getSumSq()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getSumLog(), this.getSumLog()) && multivariateSummaryStatistics.getCovariance().equals(this.getCovariance());
    }

    public int hashCode() {
        int n = 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getMax());
        n = n * 31 + MathUtils.hash(this.getMean());
        n = n * 31 + MathUtils.hash(this.getMin());
        n = n * 31 + MathUtils.hash(this.getN());
        n = n * 31 + MathUtils.hash(this.getSum());
        n = n * 31 + MathUtils.hash(this.getSumSq());
        n = n * 31 + MathUtils.hash(this.getSumLog());
        n = n * 31 + this.getCovariance().hashCode();
        return n;
    }

    private void setImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray, StorelessUnivariateStatistic[] storelessUnivariateStatisticArray2) {
        this.checkEmpty();
        this.checkDimension(storelessUnivariateStatisticArray.length);
        System.arraycopy(storelessUnivariateStatisticArray, 0, storelessUnivariateStatisticArray2, 0, storelessUnivariateStatisticArray.length);
    }

    public StorelessUnivariateStatistic[] getSumImpl() {
        return (StorelessUnivariateStatistic[])this.sumImpl.clone();
    }

    public void setSumImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.sumImpl);
    }

    public StorelessUnivariateStatistic[] getSumsqImpl() {
        return (StorelessUnivariateStatistic[])this.sumSqImpl.clone();
    }

    public void setSumsqImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.sumSqImpl);
    }

    public StorelessUnivariateStatistic[] getMinImpl() {
        return (StorelessUnivariateStatistic[])this.minImpl.clone();
    }

    public void setMinImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.minImpl);
    }

    public StorelessUnivariateStatistic[] getMaxImpl() {
        return (StorelessUnivariateStatistic[])this.maxImpl.clone();
    }

    public void setMaxImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.maxImpl);
    }

    public StorelessUnivariateStatistic[] getSumLogImpl() {
        return (StorelessUnivariateStatistic[])this.sumLogImpl.clone();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.sumLogImpl);
    }

    public StorelessUnivariateStatistic[] getGeoMeanImpl() {
        return (StorelessUnivariateStatistic[])this.geoMeanImpl.clone();
    }

    public void setGeoMeanImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.geoMeanImpl);
    }

    public StorelessUnivariateStatistic[] getMeanImpl() {
        return (StorelessUnivariateStatistic[])this.meanImpl.clone();
    }

    public void setMeanImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.meanImpl);
    }

    private void checkEmpty() {
        if (this.n > 0L) {
            throw new MathIllegalStateException(LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, this.n);
        }
    }

    private void checkDimension(int n) {
        if (n != this.k) {
            throw new DimensionMismatchException(n, this.k);
        }
    }
}

