/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public class SummaryStatistics
implements StatisticalSummary,
Serializable {
    private static final long serialVersionUID = -2021321786743555871L;
    private long n = 0L;
    private SecondMoment secondMoment = new SecondMoment();
    private Sum sum = new Sum();
    private SumOfSquares sumsq = new SumOfSquares();
    private Min min = new Min();
    private Max max = new Max();
    private SumOfLogs sumLog = new SumOfLogs();
    private GeometricMean geoMean = new GeometricMean(this.sumLog);
    private Mean mean = new Mean(this.secondMoment);
    private Variance variance = new Variance(this.secondMoment);
    private StorelessUnivariateStatistic sumImpl = this.sum;
    private StorelessUnivariateStatistic sumsqImpl = this.sumsq;
    private StorelessUnivariateStatistic minImpl = this.min;
    private StorelessUnivariateStatistic maxImpl = this.max;
    private StorelessUnivariateStatistic sumLogImpl = this.sumLog;
    private StorelessUnivariateStatistic geoMeanImpl = this.geoMean;
    private StorelessUnivariateStatistic meanImpl = this.mean;
    private StorelessUnivariateStatistic varianceImpl = this.variance;

    public SummaryStatistics() {
    }

    public SummaryStatistics(SummaryStatistics summaryStatistics) {
        SummaryStatistics.copy(summaryStatistics, this);
    }

    public StatisticalSummary getSummary() {
        return new StatisticalSummaryValues(this.getMean(), this.getVariance(), this.getN(), this.getMax(), this.getMin(), this.getSum());
    }

    public void addValue(double d) {
        this.sumImpl.increment(d);
        this.sumsqImpl.increment(d);
        this.minImpl.increment(d);
        this.maxImpl.increment(d);
        this.sumLogImpl.increment(d);
        this.secondMoment.increment(d);
        if (this.meanImpl != this.mean) {
            this.meanImpl.increment(d);
        }
        if (this.varianceImpl != this.variance) {
            this.varianceImpl.increment(d);
        }
        if (this.geoMeanImpl != this.geoMean) {
            this.geoMeanImpl.increment(d);
        }
        ++this.n;
    }

    public long getN() {
        return this.n;
    }

    public double getSum() {
        return this.sumImpl.getResult();
    }

    public double getSumsq() {
        return this.sumsqImpl.getResult();
    }

    public double getMean() {
        return this.meanImpl.getResult();
    }

    public double getStandardDeviation() {
        double d = Double.NaN;
        if (this.getN() > 0L) {
            d = this.getN() > 1L ? FastMath.sqrt(this.getVariance()) : 0.0;
        }
        return d;
    }

    public double getQuadraticMean() {
        long l = this.getN();
        return l > 0L ? FastMath.sqrt(this.getSumsq() / (double)l) : Double.NaN;
    }

    public double getVariance() {
        return this.varianceImpl.getResult();
    }

    public double getPopulationVariance() {
        Variance variance = new Variance(this.secondMoment);
        variance.setBiasCorrected(false);
        return variance.getResult();
    }

    public double getMax() {
        return this.maxImpl.getResult();
    }

    public double getMin() {
        return this.minImpl.getResult();
    }

    public double getGeometricMean() {
        return this.geoMeanImpl.getResult();
    }

    public double getSumOfLogs() {
        return this.sumLogImpl.getResult();
    }

    public double getSecondMoment() {
        return this.secondMoment.getResult();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\n";
        stringBuilder.append("SummaryStatistics:").append(string);
        stringBuilder.append("n: ").append(this.getN()).append(string);
        stringBuilder.append("min: ").append(this.getMin()).append(string);
        stringBuilder.append("max: ").append(this.getMax()).append(string);
        stringBuilder.append("sum: ").append(this.getSum()).append(string);
        stringBuilder.append("mean: ").append(this.getMean()).append(string);
        stringBuilder.append("geometric mean: ").append(this.getGeometricMean()).append(string);
        stringBuilder.append("variance: ").append(this.getVariance()).append(string);
        stringBuilder.append("population variance: ").append(this.getPopulationVariance()).append(string);
        stringBuilder.append("second moment: ").append(this.getSecondMoment()).append(string);
        stringBuilder.append("sum of squares: ").append(this.getSumsq()).append(string);
        stringBuilder.append("standard deviation: ").append(this.getStandardDeviation()).append(string);
        stringBuilder.append("sum of logs: ").append(this.getSumOfLogs()).append(string);
        return stringBuilder.toString();
    }

    public void clear() {
        this.n = 0L;
        this.minImpl.clear();
        this.maxImpl.clear();
        this.sumImpl.clear();
        this.sumLogImpl.clear();
        this.sumsqImpl.clear();
        this.geoMeanImpl.clear();
        this.secondMoment.clear();
        if (this.meanImpl != this.mean) {
            this.meanImpl.clear();
        }
        if (this.varianceImpl != this.variance) {
            this.varianceImpl.clear();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SummaryStatistics)) {
            return false;
        }
        SummaryStatistics summaryStatistics = (SummaryStatistics)object;
        return Precision.equalsIncludingNaN(summaryStatistics.getGeometricMean(), this.getGeometricMean()) && Precision.equalsIncludingNaN(summaryStatistics.getMax(), this.getMax()) && Precision.equalsIncludingNaN(summaryStatistics.getMean(), this.getMean()) && Precision.equalsIncludingNaN(summaryStatistics.getMin(), this.getMin()) && Precision.equalsIncludingNaN(summaryStatistics.getN(), this.getN()) && Precision.equalsIncludingNaN(summaryStatistics.getSum(), this.getSum()) && Precision.equalsIncludingNaN(summaryStatistics.getSumsq(), this.getSumsq()) && Precision.equalsIncludingNaN(summaryStatistics.getVariance(), this.getVariance());
    }

    public int hashCode() {
        int n = 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getMax());
        n = n * 31 + MathUtils.hash(this.getMean());
        n = n * 31 + MathUtils.hash(this.getMin());
        n = n * 31 + MathUtils.hash(this.getN());
        n = n * 31 + MathUtils.hash(this.getSum());
        n = n * 31 + MathUtils.hash(this.getSumsq());
        n = n * 31 + MathUtils.hash(this.getVariance());
        return n;
    }

    public StorelessUnivariateStatistic getSumImpl() {
        return this.sumImpl;
    }

    public void setSumImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.sumImpl = storelessUnivariateStatistic;
    }

    public StorelessUnivariateStatistic getSumsqImpl() {
        return this.sumsqImpl;
    }

    public void setSumsqImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.sumsqImpl = storelessUnivariateStatistic;
    }

    public StorelessUnivariateStatistic getMinImpl() {
        return this.minImpl;
    }

    public void setMinImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.minImpl = storelessUnivariateStatistic;
    }

    public StorelessUnivariateStatistic getMaxImpl() {
        return this.maxImpl;
    }

    public void setMaxImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.maxImpl = storelessUnivariateStatistic;
    }

    public StorelessUnivariateStatistic getSumLogImpl() {
        return this.sumLogImpl;
    }

    public void setSumLogImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.sumLogImpl = storelessUnivariateStatistic;
        this.geoMean.setSumLogImpl(storelessUnivariateStatistic);
    }

    public StorelessUnivariateStatistic getGeoMeanImpl() {
        return this.geoMeanImpl;
    }

    public void setGeoMeanImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.geoMeanImpl = storelessUnivariateStatistic;
    }

    public StorelessUnivariateStatistic getMeanImpl() {
        return this.meanImpl;
    }

    public void setMeanImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.meanImpl = storelessUnivariateStatistic;
    }

    public StorelessUnivariateStatistic getVarianceImpl() {
        return this.varianceImpl;
    }

    public void setVarianceImpl(StorelessUnivariateStatistic storelessUnivariateStatistic) {
        this.checkEmpty();
        this.varianceImpl = storelessUnivariateStatistic;
    }

    private void checkEmpty() {
        if (this.n > 0L) {
            throw new MathIllegalStateException(LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, this.n);
        }
    }

    public SummaryStatistics copy() {
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        SummaryStatistics.copy(this, summaryStatistics);
        return summaryStatistics;
    }

    public static void copy(SummaryStatistics summaryStatistics, SummaryStatistics summaryStatistics2) {
        MathUtils.checkNotNull(summaryStatistics);
        MathUtils.checkNotNull(summaryStatistics2);
        summaryStatistics2.maxImpl = summaryStatistics.maxImpl.copy();
        summaryStatistics2.minImpl = summaryStatistics.minImpl.copy();
        summaryStatistics2.sumImpl = summaryStatistics.sumImpl.copy();
        summaryStatistics2.sumLogImpl = summaryStatistics.sumLogImpl.copy();
        summaryStatistics2.sumsqImpl = summaryStatistics.sumsqImpl.copy();
        summaryStatistics2.secondMoment = summaryStatistics.secondMoment.copy();
        summaryStatistics2.n = summaryStatistics.n;
        summaryStatistics2.varianceImpl = summaryStatistics.getVarianceImpl() instanceof Variance ? new Variance(summaryStatistics2.secondMoment) : summaryStatistics.varianceImpl.copy();
        summaryStatistics2.meanImpl = summaryStatistics.meanImpl instanceof Mean ? new Mean(summaryStatistics2.secondMoment) : summaryStatistics.meanImpl.copy();
        summaryStatistics2.geoMeanImpl = summaryStatistics.getGeoMeanImpl() instanceof GeometricMean ? new GeometricMean((SumOfLogs)summaryStatistics2.sumLogImpl) : summaryStatistics.geoMeanImpl.copy();
        if (summaryStatistics.geoMean == summaryStatistics.geoMeanImpl) {
            summaryStatistics2.geoMean = (GeometricMean)summaryStatistics2.geoMeanImpl;
        } else {
            GeometricMean.copy(summaryStatistics.geoMean, summaryStatistics2.geoMean);
        }
        if (summaryStatistics.max == summaryStatistics.maxImpl) {
            summaryStatistics2.max = (Max)summaryStatistics2.maxImpl;
        } else {
            Max.copy(summaryStatistics.max, summaryStatistics2.max);
        }
        if (summaryStatistics.mean == summaryStatistics.meanImpl) {
            summaryStatistics2.mean = (Mean)summaryStatistics2.meanImpl;
        } else {
            Mean.copy(summaryStatistics.mean, summaryStatistics2.mean);
        }
        if (summaryStatistics.min == summaryStatistics.minImpl) {
            summaryStatistics2.min = (Min)summaryStatistics2.minImpl;
        } else {
            Min.copy(summaryStatistics.min, summaryStatistics2.min);
        }
        if (summaryStatistics.sum == summaryStatistics.sumImpl) {
            summaryStatistics2.sum = (Sum)summaryStatistics2.sumImpl;
        } else {
            Sum.copy(summaryStatistics.sum, summaryStatistics2.sum);
        }
        if (summaryStatistics.variance == summaryStatistics.varianceImpl) {
            summaryStatistics2.variance = (Variance)summaryStatistics2.varianceImpl;
        } else {
            Variance.copy(summaryStatistics.variance, summaryStatistics2.variance);
        }
        if (summaryStatistics.sumLog == summaryStatistics.sumLogImpl) {
            summaryStatistics2.sumLog = (SumOfLogs)summaryStatistics2.sumLogImpl;
        } else {
            SumOfLogs.copy(summaryStatistics.sumLog, summaryStatistics2.sumLog);
        }
        if (summaryStatistics.sumsq == summaryStatistics.sumsqImpl) {
            summaryStatistics2.sumsq = (SumOfSquares)summaryStatistics2.sumsqImpl;
        } else {
            SumOfSquares.copy(summaryStatistics.sumsq, summaryStatistics2.sumsq);
        }
    }
}

