/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.FourthMoment;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class Kurtosis
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 2784465764798260919L;
    protected FourthMoment moment;
    protected boolean incMoment;

    public Kurtosis() {
        this.incMoment = true;
        this.moment = new FourthMoment();
    }

    public Kurtosis(FourthMoment fourthMoment) {
        this.incMoment = false;
        this.moment = fourthMoment;
    }

    public Kurtosis(Kurtosis kurtosis) {
        Kurtosis.copy(kurtosis, this);
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public double getResult() {
        double d = Double.NaN;
        if (this.moment.getN() > 3L) {
            double d2 = this.moment.m2 / (double)(this.moment.n - 1L);
            if (this.moment.n <= 3L || d2 < 1.0E-19) {
                d = 0.0;
            } else {
                double d3 = this.moment.n;
                d = (d3 * (d3 + 1.0) * this.moment.getResult() - 3.0 * this.moment.m2 * this.moment.m2 * (d3 - 1.0)) / ((d3 - 1.0) * (d3 - 2.0) * (d3 - 3.0) * d2 * d2);
            }
        }
        return d;
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2) && n2 > 3) {
            Variance variance = new Variance();
            variance.incrementAll(dArray, n, n2);
            double d2 = variance.moment.m1;
            double d3 = FastMath.sqrt(variance.getResult());
            double d4 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d4 += FastMath.pow(dArray[i] - d2, 4.0);
            }
            double d5 = n2;
            double d6 = d5 * (d5 + 1.0) / ((d5 - 1.0) * (d5 - 2.0) * (d5 - 3.0));
            double d7 = 3.0 * FastMath.pow(d5 - 1.0, 2.0) / ((d5 - 2.0) * (d5 - 3.0));
            d = d6 * (d4 /= FastMath.pow(d3, 4.0)) - d7;
        }
        return d;
    }

    public Kurtosis copy() {
        Kurtosis kurtosis = new Kurtosis();
        Kurtosis.copy(this, kurtosis);
        return kurtosis;
    }

    public static void copy(Kurtosis kurtosis, Kurtosis kurtosis2) {
        MathUtils.checkNotNull(kurtosis);
        MathUtils.checkNotNull(kurtosis2);
        kurtosis2.setData(kurtosis.getDataRef());
        kurtosis2.moment = kurtosis.moment.copy();
        kurtosis2.incMoment = kurtosis.incMoment;
    }
}

