/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class VectorialMean
implements Serializable {
    private static final long serialVersionUID = 8223009086481006892L;
    private final Mean[] means;

    public VectorialMean(int n) {
        this.means = new Mean[n];
        for (int i = 0; i < n; ++i) {
            this.means[i] = new Mean();
        }
    }

    public void increment(double[] dArray) {
        if (dArray.length != this.means.length) {
            throw new DimensionMismatchException(dArray.length, this.means.length);
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.means[i].increment(dArray[i]);
        }
    }

    public double[] getResult() {
        double[] dArray = new double[this.means.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.means[i].getResult();
        }
        return dArray;
    }

    public long getN() {
        return this.means.length == 0 ? 0L : this.means[0].getN();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.means);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VectorialMean)) {
            return false;
        }
        VectorialMean vectorialMean = (VectorialMean)object;
        return Arrays.equals(this.means, vectorialMean.means);
    }
}

