/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class Product
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = 2824226005990582538L;
    private long n;
    private double value;

    public Product() {
        this.n = 0L;
        this.value = 1.0;
    }

    public Product(Product product) {
        Product.copy(product, this);
    }

    public void increment(double d) {
        this.value *= d;
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 1.0;
        this.n = 0L;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2, true)) {
            d = 1.0;
            for (int i = n; i < n + n2; ++i) {
                d *= dArray[i];
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, dArray2, n, n2, true)) {
            d = 1.0;
            for (int i = n; i < n + n2; ++i) {
                d *= FastMath.pow(dArray[i], dArray2[i]);
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public Product copy() {
        Product product = new Product();
        Product.copy(this, product);
        return product;
    }

    public static void copy(Product product, Product product2) {
        MathUtils.checkNotNull(product);
        MathUtils.checkNotNull(product2);
        product2.setData(product.getDataRef());
        product2.n = product.n;
        product2.value = product.value;
    }
}

