/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.util.MathUtils;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8231831954703408316L;
    private long n;
    private double value;

    public Sum() {
        this.n = 0L;
        this.value = 0.0;
    }

    public Sum(Sum sum) {
        Sum.copy(sum, this);
    }

    public void increment(double d) {
        this.value += d;
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i];
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, dArray2, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i] * dArray2[i];
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public Sum copy() {
        Sum sum = new Sum();
        Sum.copy(this, sum);
        return sum;
    }

    public static void copy(Sum sum, Sum sum2) {
        MathUtils.checkNotNull(sum);
        MathUtils.checkNotNull(sum2);
        sum2.setData(sum.getDataRef());
        sum2.n = sum.n;
        sum2.value = sum.value;
    }
}

