/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs sumOfLogs) {
        SumOfLogs.copy(sumOfLogs, this);
    }

    public void increment(double d) {
        this.value += FastMath.log(d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += FastMath.log(dArray[i]);
            }
        }
        return d;
    }

    public SumOfLogs copy() {
        SumOfLogs sumOfLogs = new SumOfLogs();
        SumOfLogs.copy(this, sumOfLogs);
        return sumOfLogs;
    }

    public static void copy(SumOfLogs sumOfLogs, SumOfLogs sumOfLogs2) {
        MathUtils.checkNotNull(sumOfLogs);
        MathUtils.checkNotNull(sumOfLogs2);
        sumOfLogs2.setData(sumOfLogs.getDataRef());
        sumOfLogs2.n = sumOfLogs.n;
        sumOfLogs2.value = sumOfLogs.value;
    }
}

