/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.util.MathUtils;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 1460986908574398008L;
    private long n;
    private double value;

    public SumOfSquares() {
        this.n = 0L;
        this.value = 0.0;
    }

    public SumOfSquares(SumOfSquares sumOfSquares) {
        SumOfSquares.copy(sumOfSquares, this);
    }

    public void increment(double d) {
        this.value += d * d;
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return d;
    }

    public SumOfSquares copy() {
        SumOfSquares sumOfSquares = new SumOfSquares();
        SumOfSquares.copy(this, sumOfSquares);
        return sumOfSquares;
    }

    public static void copy(SumOfSquares sumOfSquares, SumOfSquares sumOfSquares2) {
        MathUtils.checkNotNull(sumOfSquares);
        MathUtils.checkNotNull(sumOfSquares2);
        sumOfSquares2.setData(sumOfSquares.getDataRef());
        sumOfSquares2.n = sumOfSquares.n;
        sumOfSquares2.value = sumOfSquares.value;
    }
}

