/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class ChiSquareTest {
    public double chiSquare(double[] dArray, long[] lArray) {
        if (dArray.length < 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        if (dArray.length != lArray.length) {
            throw new DimensionMismatchException(dArray.length, lArray.length);
        }
        MathArrays.checkPositive(dArray);
        MathArrays.checkNonNegative(lArray);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            d += dArray[i];
            d2 += (double)lArray[i];
        }
        double d3 = 1.0;
        boolean bl = false;
        if (FastMath.abs(d - d2) > 1.0E-5) {
            d3 = d2 / d;
            bl = true;
        }
        double d4 = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            double d5;
            if (bl) {
                d5 = (double)lArray[i] - d3 * dArray[i];
                d4 += d5 * d5 / (d3 * dArray[i]);
                continue;
            }
            d5 = (double)lArray[i] - dArray[i];
            d4 += d5 * d5 / dArray[i];
        }
        return d4;
    }

    public double chiSquareTest(double[] dArray, long[] lArray) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)dArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(dArray, lArray));
    }

    public boolean chiSquareTest(double[] dArray, long[] lArray, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.chiSquareTest(dArray, lArray) < d;
    }

    public double chiSquare(long[][] lArray) {
        this.checkArray(lArray);
        int n = lArray.length;
        int n2 = lArray[0].length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n2];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                dArray[n3] = dArray[n3] + (double)lArray[i][j];
                int n4 = j;
                dArray2[n4] = dArray2[n4] + (double)lArray[i][j];
                d += (double)lArray[i][j];
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                d3 = dArray[i] * dArray2[j] / d;
                d2 += ((double)lArray[i][j] - d3) * ((double)lArray[i][j] - d3) / d3;
            }
        }
        return d2;
    }

    public double chiSquareTest(long[][] lArray) {
        this.checkArray(lArray);
        double d = ((double)lArray.length - 1.0) * ((double)lArray[0].length - 1.0);
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(d);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(lArray));
    }

    public boolean chiSquareTest(long[][] lArray, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.chiSquareTest(lArray) < d;
    }

    public double chiSquareDataSetsComparison(long[] lArray, long[] lArray2) {
        if (lArray.length < 2) {
            throw new DimensionMismatchException(lArray.length, 2);
        }
        if (lArray.length != lArray2.length) {
            throw new DimensionMismatchException(lArray.length, lArray2.length);
        }
        MathArrays.checkNonNegative(lArray);
        MathArrays.checkNonNegative(lArray2);
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
            l2 += lArray2[i];
        }
        if (l == 0L || l2 == 0L) {
            throw new ZeroException();
        }
        boolean bl2 = bl = l != l2;
        if (bl) {
            d = FastMath.sqrt((double)l / (double)l2);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L && lArray2[i] == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, i);
            }
            d4 = lArray[i];
            d5 = lArray2[i];
            d3 = bl ? d4 / d - d5 * d : d4 - d5;
            d2 += d3 * d3 / (d4 + d5);
        }
        return d2;
    }

    public double chiSquareTestDataSetsComparison(long[] lArray, long[] lArray2) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)lArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquareDataSetsComparison(lArray, lArray2));
    }

    public boolean chiSquareTestDataSetsComparison(long[] lArray, long[] lArray2, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.chiSquareTestDataSetsComparison(lArray, lArray2) < d;
    }

    private void checkArray(long[][] lArray) {
        if (lArray.length < 2) {
            throw new DimensionMismatchException(lArray.length, 2);
        }
        if (lArray[0].length < 2) {
            throw new DimensionMismatchException(lArray[0].length, 2);
        }
        MathArrays.checkRectangular(lArray);
        MathArrays.checkNonNegative(lArray);
    }
}

