/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.interval;

import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math3.stat.interval.ConfidenceInterval;
import org.apache.commons.math3.stat.interval.IntervalUtils;

public class ClopperPearsonInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = (1.0 - d) / 2.0;
        FDistribution fDistribution = new FDistribution(2 * (n - n2 + 1), 2 * n2);
        double d5 = fDistribution.inverseCumulativeProbability(1.0 - d4);
        if (n2 > 0) {
            d2 = (double)n2 / ((double)n2 + (double)(n - n2 + 1) * d5);
        }
        FDistribution fDistribution2 = new FDistribution(2 * (n2 + 1), 2 * (n - n2));
        double d6 = fDistribution2.inverseCumulativeProbability(1.0 - d4);
        if (n2 > 0) {
            d3 = (double)(n2 + 1) * d6 / ((double)(n - n2) + (double)(n2 + 1) * d6);
        }
        return new ConfidenceInterval(d2, d3, d);
    }
}

