/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.interval;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math3.stat.interval.ConfidenceInterval;
import org.apache.commons.math3.stat.interval.IntervalUtils;
import org.apache.commons.math3.util.FastMath;

public class WilsonScoreInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = (1.0 - d) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution();
        double d3 = normalDistribution.inverseCumulativeProbability(1.0 - d2);
        double d4 = FastMath.pow(d3, 2);
        double d5 = (double)n2 / (double)n;
        double d6 = 1.0 / (1.0 + 1.0 / (double)n * d4);
        double d7 = d5 + 1.0 / (double)(2 * n) * d4;
        double d8 = d3 * FastMath.sqrt(1.0 / (double)n * d5 * (1.0 - d5) + 1.0 / (4.0 * FastMath.pow((double)n, 2)) * d4);
        double d9 = d6 * (d7 - d8);
        double d10 = d6 * (d7 + d8);
        return new ConfidenceInterval(d9, d10, d);
    }
}

