/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.ranking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.RankingAlgorithm;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalRanking
implements RankingAlgorithm {
    public static final NaNStrategy DEFAULT_NAN_STRATEGY = NaNStrategy.FAILED;
    public static final TiesStrategy DEFAULT_TIES_STRATEGY = TiesStrategy.AVERAGE;
    private final NaNStrategy nanStrategy;
    private final TiesStrategy tiesStrategy;
    private final RandomDataGenerator randomData;

    public NaturalRanking() {
        this.tiesStrategy = DEFAULT_TIES_STRATEGY;
        this.nanStrategy = DEFAULT_NAN_STRATEGY;
        this.randomData = null;
    }

    public NaturalRanking(TiesStrategy tiesStrategy) {
        this.tiesStrategy = tiesStrategy;
        this.nanStrategy = DEFAULT_NAN_STRATEGY;
        this.randomData = new RandomDataGenerator();
    }

    public NaturalRanking(NaNStrategy naNStrategy) {
        this.nanStrategy = naNStrategy;
        this.tiesStrategy = DEFAULT_TIES_STRATEGY;
        this.randomData = null;
    }

    public NaturalRanking(NaNStrategy naNStrategy, TiesStrategy tiesStrategy) {
        this.nanStrategy = naNStrategy;
        this.tiesStrategy = tiesStrategy;
        this.randomData = new RandomDataGenerator();
    }

    public NaturalRanking(RandomGenerator randomGenerator) {
        this.tiesStrategy = TiesStrategy.RANDOM;
        this.nanStrategy = DEFAULT_NAN_STRATEGY;
        this.randomData = new RandomDataGenerator(randomGenerator);
    }

    public NaturalRanking(NaNStrategy naNStrategy, RandomGenerator randomGenerator) {
        this.nanStrategy = naNStrategy;
        this.tiesStrategy = TiesStrategy.RANDOM;
        this.randomData = new RandomDataGenerator(randomGenerator);
    }

    public NaNStrategy getNanStrategy() {
        return this.nanStrategy;
    }

    public TiesStrategy getTiesStrategy() {
        return this.tiesStrategy;
    }

    @Override
    public double[] rank(double[] dArray) {
        Object[] objectArray = new IntDoublePair[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i] = new IntDoublePair(dArray[i], i);
        }
        List<Integer> list = null;
        switch (this.nanStrategy) {
            case MAXIMAL: {
                this.recodeNaNs((IntDoublePair[])objectArray, Double.POSITIVE_INFINITY);
                break;
            }
            case MINIMAL: {
                this.recodeNaNs((IntDoublePair[])objectArray, Double.NEGATIVE_INFINITY);
                break;
            }
            case REMOVED: {
                objectArray = this.removeNaNs((IntDoublePair[])objectArray);
                break;
            }
            case FIXED: {
                list = this.getNanPositions((IntDoublePair[])objectArray);
                break;
            }
            case FAILED: {
                list = this.getNanPositions((IntDoublePair[])objectArray);
                if (list.size() <= 0) break;
                throw new NotANumberException();
            }
            default: {
                throw new MathInternalError();
            }
        }
        Arrays.sort(objectArray);
        double[] dArray2 = new double[objectArray.length];
        int n = 1;
        dArray2[((IntDoublePair)objectArray[0]).getPosition()] = n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(((IntDoublePair)objectArray[0]).getPosition());
        for (int i = 1; i < objectArray.length; ++i) {
            if (Double.compare(((IntDoublePair)objectArray[i]).getValue(), ((IntDoublePair)objectArray[i - 1]).getValue()) > 0) {
                n = i + 1;
                if (arrayList.size() > 1) {
                    this.resolveTie(dArray2, arrayList);
                }
                arrayList = new ArrayList();
                arrayList.add(((IntDoublePair)objectArray[i]).getPosition());
            } else {
                arrayList.add(((IntDoublePair)objectArray[i]).getPosition());
            }
            dArray2[((IntDoublePair)objectArray[i]).getPosition()] = n;
        }
        if (arrayList.size() > 1) {
            this.resolveTie(dArray2, arrayList);
        }
        if (this.nanStrategy == NaNStrategy.FIXED) {
            this.restoreNaNs(dArray2, list);
        }
        return dArray2;
    }

    private IntDoublePair[] removeNaNs(IntDoublePair[] intDoublePairArray) {
        if (!this.containsNaNs(intDoublePairArray)) {
            return intDoublePairArray;
        }
        IntDoublePair[] intDoublePairArray2 = new IntDoublePair[intDoublePairArray.length];
        int n = 0;
        for (int i = 0; i < intDoublePairArray.length; ++i) {
            if (Double.isNaN(intDoublePairArray[i].getValue())) {
                for (int j = i + 1; j < intDoublePairArray.length; ++j) {
                    intDoublePairArray[j] = new IntDoublePair(intDoublePairArray[j].getValue(), intDoublePairArray[j].getPosition() - 1);
                }
                continue;
            }
            intDoublePairArray2[n] = new IntDoublePair(intDoublePairArray[i].getValue(), intDoublePairArray[i].getPosition());
            ++n;
        }
        IntDoublePair[] intDoublePairArray3 = new IntDoublePair[n];
        System.arraycopy(intDoublePairArray2, 0, intDoublePairArray3, 0, n);
        return intDoublePairArray3;
    }

    private void recodeNaNs(IntDoublePair[] intDoublePairArray, double d) {
        for (int i = 0; i < intDoublePairArray.length; ++i) {
            if (!Double.isNaN(intDoublePairArray[i].getValue())) continue;
            intDoublePairArray[i] = new IntDoublePair(d, intDoublePairArray[i].getPosition());
        }
    }

    private boolean containsNaNs(IntDoublePair[] intDoublePairArray) {
        for (int i = 0; i < intDoublePairArray.length; ++i) {
            if (!Double.isNaN(intDoublePairArray[i].getValue())) continue;
            return true;
        }
        return false;
    }

    private void resolveTie(double[] dArray, List<Integer> list) {
        double d = dArray[list.get(0)];
        int n = list.size();
        switch (this.tiesStrategy) {
            case AVERAGE: {
                this.fill(dArray, list, (2.0 * d + (double)n - 1.0) / 2.0);
                break;
            }
            case MAXIMUM: {
                this.fill(dArray, list, d + (double)n - 1.0);
                break;
            }
            case MINIMUM: {
                this.fill(dArray, list, d);
                break;
            }
            case RANDOM: {
                Iterator<Integer> iterator = list.iterator();
                long l = FastMath.round(d);
                while (iterator.hasNext()) {
                    dArray[iterator.next().intValue()] = this.randomData.nextLong(l, l + (long)n - 1L);
                }
                break;
            }
            case SEQUENTIAL: {
                Iterator<Integer> iterator = list.iterator();
                long l = FastMath.round(d);
                int n2 = 0;
                while (iterator.hasNext()) {
                    dArray[iterator.next().intValue()] = l + (long)n2++;
                }
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
    }

    private void fill(double[] dArray, List<Integer> list, double d) {
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            dArray[iterator.next().intValue()] = d;
        }
    }

    private void restoreNaNs(double[] dArray, List<Integer> list) {
        if (list.size() == 0) {
            return;
        }
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            dArray[iterator.next().intValue()] = Double.NaN;
        }
    }

    private List<Integer> getNanPositions(IntDoublePair[] intDoublePairArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < intDoublePairArray.length; ++i) {
            if (!Double.isNaN(intDoublePairArray[i].getValue())) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntDoublePair
    implements Comparable<IntDoublePair> {
        private final double value;
        private final int position;

        IntDoublePair(double d, int n) {
            this.value = d;
            this.position = n;
        }

        @Override
        public int compareTo(IntDoublePair intDoublePair) {
            return Double.compare(this.value, intDoublePair.value);
        }

        public double getValue() {
            return this.value;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

