/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import java.util.Arrays;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.regression.ModelSpecificationException;
import org.apache.commons.math3.stat.regression.RegressionResults;
import org.apache.commons.math3.stat.regression.UpdatingMultipleLinearRegression;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;

public class MillerUpdatingRegression
implements UpdatingMultipleLinearRegression {
    private final int nvars;
    private final double[] d;
    private final double[] rhs;
    private final double[] r;
    private final double[] tol;
    private final double[] rss;
    private final int[] vorder;
    private final double[] work_tolset;
    private long nobs = 0L;
    private double sserr = 0.0;
    private boolean rss_set = false;
    private boolean tol_set = false;
    private final boolean[] lindep;
    private final double[] x_sing;
    private final double[] work_sing;
    private double sumy = 0.0;
    private double sumsqy = 0.0;
    private boolean hasIntercept;
    private final double epsilon;

    private MillerUpdatingRegression() {
        this(-1, false, Double.NaN);
    }

    public MillerUpdatingRegression(int n, boolean bl, double d) {
        if (n < 1) {
            throw new ModelSpecificationException(LocalizedFormats.NO_REGRESSORS, new Object[0]);
        }
        this.nvars = bl ? n + 1 : n;
        this.hasIntercept = bl;
        this.nobs = 0L;
        this.d = new double[this.nvars];
        this.rhs = new double[this.nvars];
        this.r = new double[this.nvars * (this.nvars - 1) / 2];
        this.tol = new double[this.nvars];
        this.rss = new double[this.nvars];
        this.vorder = new int[this.nvars];
        this.x_sing = new double[this.nvars];
        this.work_sing = new double[this.nvars];
        this.work_tolset = new double[this.nvars];
        this.lindep = new boolean[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            this.vorder[i] = i;
        }
        this.epsilon = d > 0.0 ? d : -d;
    }

    public MillerUpdatingRegression(int n, boolean bl) {
        this(n, bl, Precision.EPSILON);
    }

    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    public long getN() {
        return this.nobs;
    }

    public void addObservation(double[] dArray, double d) {
        if (!this.hasIntercept && dArray.length != this.nvars || this.hasIntercept && dArray.length + 1 != this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.INVALID_REGRESSION_OBSERVATION, dArray.length, this.nvars);
        }
        if (!this.hasIntercept) {
            this.include(MathArrays.copyOf(dArray, dArray.length), 1.0, d);
        } else {
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
            dArray2[0] = 1.0;
            this.include(dArray2, 1.0, d);
        }
        ++this.nobs;
    }

    public void addObservations(double[][] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            throw new ModelSpecificationException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, dArray == null ? 0 : dArray.length, dArray2 == null ? 0 : dArray2.length);
        }
        if (dArray.length == 0) {
            throw new ModelSpecificationException(LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (dArray[0].length + 1 > dArray.length) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, dArray.length, dArray[0].length);
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.addObservation(dArray[i], dArray2[i]);
        }
    }

    private void include(double[] dArray, double d, double d2) {
        int n = 0;
        double d3 = d;
        double d4 = d2;
        this.rss_set = false;
        this.sumy = this.smartAdd(d2, this.sumy);
        this.sumsqy = this.smartAdd(this.sumsqy, d2 * d2);
        for (int i = 0; i < dArray.length; ++i) {
            double d5;
            double d6;
            if (d3 == 0.0) {
                return;
            }
            double d7 = dArray[i];
            if (d7 == 0.0) {
                n += this.nvars - i - 1;
                continue;
            }
            double d8 = this.d[i];
            double d9 = d3 * d7;
            double d10 = d3;
            if (d8 != 0.0) {
                d6 = this.smartAdd(d8, d9 * d7);
                double d11 = d9 * d7 / d8;
                if (FastMath.abs(d11) > Precision.EPSILON) {
                    d3 = d8 * d3 / d6;
                }
            } else {
                d6 = d9 * d7;
                d3 = 0.0;
            }
            this.d[i] = d6;
            for (int j = i + 1; j < this.nvars; ++j) {
                d5 = dArray[j];
                dArray[j] = this.smartAdd(d5, -d7 * this.r[n]);
                this.r[n] = d8 != 0.0 ? this.smartAdd(d8 * this.r[n], d10 * d7 * d5) / d6 : d5 / d7;
                ++n;
            }
            d5 = d4;
            d4 = this.smartAdd(d5, -d7 * this.rhs[i]);
            this.rhs[i] = d8 != 0.0 ? this.smartAdd(d8 * this.rhs[i], d9 * d5) / d6 : d5 / d7;
        }
        this.sserr = this.smartAdd(this.sserr, d3 * d4 * d4);
    }

    private double smartAdd(double d, double d2) {
        double d3;
        double d4 = FastMath.abs(d);
        if (d4 > (d3 = FastMath.abs(d2))) {
            double d5 = d4 * Precision.EPSILON;
            if (d3 > d5) {
                return d + d2;
            }
            return d;
        }
        double d6 = d3 * Precision.EPSILON;
        if (d4 > d6) {
            return d + d2;
        }
        return d2;
    }

    public void clear() {
        Arrays.fill(this.d, 0.0);
        Arrays.fill(this.rhs, 0.0);
        Arrays.fill(this.r, 0.0);
        Arrays.fill(this.tol, 0.0);
        Arrays.fill(this.rss, 0.0);
        Arrays.fill(this.work_tolset, 0.0);
        Arrays.fill(this.work_sing, 0.0);
        Arrays.fill(this.x_sing, 0.0);
        Arrays.fill(this.lindep, false);
        for (int i = 0; i < this.nvars; ++i) {
            this.vorder[i] = i;
        }
        this.nobs = 0L;
        this.sserr = 0.0;
        this.sumy = 0.0;
        this.sumsqy = 0.0;
        this.rss_set = false;
        this.tol_set = false;
    }

    private void tolset() {
        int n;
        double d = this.epsilon;
        for (n = 0; n < this.nvars; ++n) {
            this.work_tolset[n] = FastMath.sqrt(this.d[n]);
        }
        this.tol[0] = d * this.work_tolset[0];
        for (n = 1; n < this.nvars; ++n) {
            int n2 = n - 1;
            double d2 = this.work_tolset[n];
            for (int i = 0; i < n; ++i) {
                d2 += FastMath.abs(this.r[n2]) * this.work_tolset[i];
                n2 += this.nvars - i - 2;
            }
            this.tol[n] = d * d2;
        }
        this.tol_set = true;
    }

    private double[] regcf(int n) {
        int n2;
        if (n < 1) {
            throw new ModelSpecificationException(LocalizedFormats.NO_REGRESSORS, new Object[0]);
        }
        if (n > this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.TOO_MANY_REGRESSORS, n, this.nvars);
        }
        if (!this.tol_set) {
            this.tolset();
        }
        double[] dArray = new double[n];
        boolean bl = false;
        for (n2 = n - 1; n2 > -1; --n2) {
            if (FastMath.sqrt(this.d[n2]) < this.tol[n2]) {
                dArray[n2] = 0.0;
                this.d[n2] = 0.0;
                bl = true;
                continue;
            }
            dArray[n2] = this.rhs[n2];
            int n3 = n2 * (this.nvars + this.nvars - n2 - 1) / 2;
            for (int i = n2 + 1; i < n; ++i) {
                dArray[n2] = this.smartAdd(dArray[n2], -this.r[n3] * dArray[i]);
                ++n3;
            }
        }
        if (bl) {
            for (n2 = 0; n2 < n; ++n2) {
                if (!this.lindep[n2]) continue;
                dArray[n2] = Double.NaN;
            }
        }
        return dArray;
    }

    private void singcheck() {
        int n;
        for (n = 0; n < this.nvars; ++n) {
            this.work_sing[n] = FastMath.sqrt(this.d[n]);
        }
        for (n = 0; n < this.nvars; ++n) {
            int n2;
            double d = this.tol[n];
            int n3 = n - 1;
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (FastMath.abs(this.r[n3]) * this.work_sing[n2] < d) {
                    this.r[n3] = 0.0;
                }
                n3 += this.nvars - n2 - 2;
            }
            this.lindep[n] = false;
            if (!(this.work_sing[n] < d)) continue;
            this.lindep[n] = true;
            if (n < this.nvars - 1) {
                Arrays.fill(this.x_sing, 0.0);
                n2 = n * (this.nvars + this.nvars - n - 1) / 2;
                int n4 = n + 1;
                while (n4 < this.nvars) {
                    this.x_sing[n4] = this.r[n2];
                    this.r[n2] = 0.0;
                    ++n4;
                    ++n2;
                }
                double d2 = this.rhs[n];
                double d3 = this.d[n];
                this.d[n] = 0.0;
                this.rhs[n] = 0.0;
                this.include(this.x_sing, d3, d2);
                continue;
            }
            this.sserr += this.d[n] * this.rhs[n] * this.rhs[n];
        }
    }

    private void ss() {
        double d = this.sserr;
        this.rss[this.nvars - 1] = this.sserr;
        for (int i = this.nvars - 1; i > 0; --i) {
            this.rss[i - 1] = d += this.d[i] * this.rhs[i] * this.rhs[i];
        }
        this.rss_set = true;
    }

    private double[] cov(int n) {
        if (this.nobs <= (long)n) {
            return null;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.lindep[i]) continue;
            d += 1.0;
        }
        double d2 = this.rss[n - 1] / ((double)this.nobs - d);
        double[] dArray = new double[n * (n - 1) / 2];
        this.inverse(dArray, n);
        double[] dArray2 = new double[n * (n + 1) / 2];
        Arrays.fill(dArray2, Double.NaN);
        int n2 = 0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            if (!this.lindep[i]) {
                for (int j = i; j < n; ++j) {
                    if (!this.lindep[j]) {
                        int n4 = n2 + j - i;
                        d3 = i == j ? 1.0 / this.d[j] : dArray[n4 - 1] / this.d[j];
                        for (int k = j + 1; k < n; ++k) {
                            if (!this.lindep[k]) {
                                d3 += dArray[n4] * dArray[n3] / this.d[k];
                            }
                            ++n4;
                            ++n3;
                        }
                        dArray2[(j + 1) * j / 2 + i] = d3 * d2;
                        continue;
                    }
                    n3 += n - j - 1;
                }
            }
            n2 += n - i - 1;
        }
        return dArray2;
    }

    private void inverse(double[] dArray, int n) {
        int n2 = n * (n - 1) / 2 - 1;
        int n3 = -1;
        int n4 = -1;
        double d = 0.0;
        Arrays.fill(dArray, Double.NaN);
        for (int i = n - 1; i > 0; --i) {
            if (!this.lindep[i]) {
                int n5 = (i - 1) * (this.nvars + this.nvars - i) / 2;
                for (int j = n; j > i; --j) {
                    n3 = n5;
                    n4 = n2;
                    d = 0.0;
                    for (int k = i; k < j - 1; ++k) {
                        n4 += n - k - 1;
                        if (!this.lindep[k]) {
                            d += -this.r[n3] * dArray[n4];
                        }
                        ++n3;
                    }
                    dArray[n2] = d - this.r[n3];
                    --n2;
                }
                continue;
            }
            n2 -= n - i;
        }
    }

    public double[] getPartialCorrelations(int n) {
        int n2;
        int n3;
        int n4;
        double[] dArray = new double[(this.nvars - n + 1) * (this.nvars - n) / 2];
        int n5 = -n;
        int n6 = -(n + 1);
        double[] dArray2 = new double[this.nvars - n];
        double[] dArray3 = new double[this.nvars - n - 1];
        int n7 = (this.nvars - n) * (this.nvars - n - 1) / 2;
        if (n < -1 || n >= this.nvars) {
            return null;
        }
        int n8 = this.nvars - 1;
        int n9 = this.r.length - (n8 - n) * (n8 - n + 1) / 2;
        if (this.d[n] > 0.0) {
            dArray2[n + n5] = 1.0 / FastMath.sqrt(this.d[n]);
        }
        for (n4 = n + 1; n4 < this.nvars; ++n4) {
            n3 = n9 + n4 - 1 - n;
            double d = this.d[n4];
            for (n2 = n; n2 < n4; ++n2) {
                d += this.d[n2] * this.r[n3] * this.r[n3];
                n3 += this.nvars - n2 - 2;
            }
            dArray2[n4 + n5] = d > 0.0 ? 1.0 / FastMath.sqrt(d) : 0.0;
        }
        double d = this.sserr;
        for (n4 = n; n4 < this.nvars; ++n4) {
            d += this.d[n4] * this.rhs[n4] * this.rhs[n4];
        }
        if (d > 0.0) {
            d = 1.0 / FastMath.sqrt(d);
        }
        n3 = 0;
        for (n4 = n; n4 < this.nvars; ++n4) {
            int n10;
            double d2 = 0.0;
            Arrays.fill(dArray3, 0.0);
            int n11 = n9 + n4 - n - 1;
            for (n2 = n; n2 < n4; ++n2) {
                n10 = n11 + 1;
                for (int i = n4 + 1; i < this.nvars; ++i) {
                    int n12 = i + n6;
                    dArray3[n12] = dArray3[n12] + this.d[n2] * this.r[n11] * this.r[n10];
                    ++n10;
                }
                d2 += this.d[n2] * this.r[n11] * this.rhs[n2];
                n11 += this.nvars - n2 - 2;
            }
            n10 = n11 + 1;
            for (n2 = n4 + 1; n2 < this.nvars; ++n2) {
                int n13 = n2 + n6;
                dArray3[n13] = dArray3[n13] + this.d[n4] * this.r[n10];
                ++n10;
                dArray[(n2 - 1 - n) * (n2 - n) / 2 + n4 - n] = dArray3[n2 + n6] * dArray2[n4 + n5] * dArray2[n2 + n5];
                ++n3;
            }
            dArray[n4 + n5 + n7] = (d2 += this.d[n4] * this.rhs[n4]) * dArray2[n4 + n5] * d;
        }
        return dArray;
    }

    private void vmove(int n, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        if (n == n2) {
            return;
        }
        if (!this.rss_set) {
            this.ss();
        }
        int n5 = 0;
        if (n < n2) {
            n4 = n;
            n3 = 1;
            n5 = n2 - n;
        } else {
            n4 = n - 1;
            n3 = -1;
            n5 = n - n2;
        }
        int n6 = n4;
        for (int i = 0; i < n5; ++i) {
            int n7;
            double d;
            int n8 = n6 * (this.nvars + this.nvars - n6 - 1) / 2;
            int n9 = n8 + this.nvars - n6 - 1;
            int n10 = n6 + 1;
            double d2 = this.d[n6];
            double d3 = this.d[n10];
            if (d2 > this.epsilon || d3 > this.epsilon) {
                d = this.r[n8];
                if (FastMath.abs(d) * FastMath.sqrt(d2) < this.tol[n10]) {
                    d = 0.0;
                }
                if (d2 < this.epsilon || FastMath.abs(d) < this.epsilon) {
                    this.d[n6] = d3;
                    this.d[n10] = d2;
                    this.r[n8] = 0.0;
                    for (n7 = n6 + 2; n7 < this.nvars; ++n7) {
                        d = this.r[++n8];
                        this.r[n8] = this.r[n9];
                        this.r[n9] = d;
                        ++n9;
                    }
                    d = this.rhs[n6];
                    this.rhs[n6] = this.rhs[n10];
                    this.rhs[n10] = d;
                    bl = true;
                } else if (d3 < this.epsilon) {
                    this.d[n6] = d2 * d * d;
                    this.r[n8] = 1.0 / d;
                    n7 = n8 + 1;
                    while (n7 < n8 + this.nvars - n6 - 1) {
                        int n11 = n7++;
                        this.r[n11] = this.r[n11] / d;
                    }
                    int n12 = n6;
                    this.rhs[n12] = this.rhs[n12] / d;
                    bl = true;
                }
                if (!bl) {
                    double d4;
                    double d5 = d3 + d2 * d * d;
                    double d6 = d3 / d5;
                    double d7 = d * d2 / d5;
                    double d8 = d2 * d6;
                    this.d[n6] = d5;
                    this.d[n10] = d8;
                    this.r[n8] = d7;
                    for (n7 = n6 + 2; n7 < this.nvars; ++n7) {
                        d4 = this.r[++n8];
                        this.r[n8] = d6 * this.r[n9] + d7 * d4;
                        this.r[n9] = d4 - d * this.r[n9];
                        ++n9;
                    }
                    d4 = this.rhs[n6];
                    this.rhs[n6] = d6 * this.rhs[n10] + d7 * d4;
                    this.rhs[n10] = d4 - d * this.rhs[n10];
                }
            }
            if (n6 > 0) {
                int n13 = n6;
                for (n7 = 0; n7 < n6; ++n7) {
                    d = this.r[n13];
                    this.r[n13] = this.r[n13 - 1];
                    this.r[n13 - 1] = d;
                    n13 += this.nvars - n7 - 2;
                }
            }
            n8 = this.vorder[n6];
            this.vorder[n6] = this.vorder[n10];
            this.vorder[n10] = n8;
            d = this.tol[n6];
            this.tol[n6] = this.tol[n10];
            this.tol[n10] = d;
            this.rss[n6] = this.rss[n10] + this.d[n10] * this.rhs[n10] * this.rhs[n10];
            n6 += n3;
        }
    }

    private int reorderRegressors(int[] nArray, int n) {
        if (nArray.length < 1 || nArray.length > this.nvars + 1 - n) {
            return -1;
        }
        int n2 = n;
        block0: for (int i = n; i < this.nvars; ++i) {
            int n3 = this.vorder[i];
            for (int j = 0; j < nArray.length; ++j) {
                if (n3 != nArray[j] || i <= n2) continue;
                this.vmove(i, n2);
                if (++n2 < nArray.length + n) continue block0;
                return 0;
            }
        }
        return 0;
    }

    public double getDiagonalOfHatMatrix(double[] dArray) {
        double[] dArray2;
        double[] dArray3 = new double[this.nvars];
        if (dArray.length > this.nvars) {
            return Double.NaN;
        }
        if (this.hasIntercept) {
            dArray2 = new double[dArray.length + 1];
            dArray2[0] = 1.0;
            System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        } else {
            dArray2 = dArray;
        }
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            if (FastMath.sqrt(this.d[i]) < this.tol[i]) {
                dArray3[i] = 0.0;
                continue;
            }
            int n = i - 1;
            double d2 = dArray2[i];
            for (int j = 0; j < i; ++j) {
                d2 = this.smartAdd(d2, -dArray3[j] * this.r[n]);
                n += this.nvars - j - 2;
            }
            dArray3[i] = d2;
            d = this.smartAdd(d, d2 * d2 / this.d[i]);
        }
        return d;
    }

    public int[] getOrderOfRegressors() {
        return MathArrays.copyOf(this.vorder);
    }

    public RegressionResults regress() {
        return this.regress(this.nvars);
    }

    public RegressionResults regress(int n) {
        int n2;
        int n3;
        int n4;
        if (this.nobs <= (long)n) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, this.nobs, n);
        }
        if (n > this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.TOO_MANY_REGRESSORS, n, this.nvars);
        }
        this.tolset();
        this.singcheck();
        double[] dArray = this.regcf(n);
        this.ss();
        double[] dArray2 = this.cov(n);
        int n5 = 0;
        for (n4 = 0; n4 < this.lindep.length; ++n4) {
            if (this.lindep[n4]) continue;
            ++n5;
        }
        n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.vorder[i] == i) continue;
            n4 = 1;
            break;
        }
        if (n4 == 0) {
            return new RegressionResults(dArray, new double[][]{dArray2}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
        }
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        int[] nArray = new int[dArray.length];
        for (n3 = 0; n3 < this.nvars; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                if (this.vorder[n2] != n3) continue;
                dArray3[n3] = dArray[n2];
                nArray[n3] = n2;
            }
        }
        n3 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            int n6 = nArray[i];
            int n7 = 0;
            while (n7 <= i) {
                int n8 = nArray[n7];
                n2 = n6 > n8 ? n6 * (n6 + 1) / 2 + n8 : n8 * (n8 + 1) / 2 + n6;
                dArray4[n3] = dArray2[n2];
                ++n7;
                ++n3;
            }
        }
        return new RegressionResults(dArray3, new double[][]{dArray4}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
    }

    public RegressionResults regress(int[] nArray) {
        int n;
        int n2;
        int[] nArray2;
        if (nArray.length > this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.TOO_MANY_REGRESSORS, nArray.length, this.nvars);
        }
        if (this.nobs <= (long)this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, this.nobs, this.nvars);
        }
        Arrays.sort(nArray);
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i >= this.nvars) {
                throw new ModelSpecificationException(LocalizedFormats.INDEX_LARGER_THAN_MAX, i, this.nvars);
            }
            if (i <= 0 || nArray[i] != nArray[i - 1]) continue;
            nArray[i] = -1;
            ++n3;
        }
        if (n3 > 0) {
            int n4 = 0;
            nArray2 = new int[nArray.length - n3];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= -1) continue;
                nArray2[n4] = nArray[i];
                ++n4;
            }
        } else {
            nArray2 = nArray;
        }
        this.reorderRegressors(nArray2, 0);
        this.tolset();
        this.singcheck();
        double[] dArray = this.regcf(nArray2.length);
        this.ss();
        double[] dArray2 = this.cov(nArray2.length);
        int n5 = 0;
        for (n2 = 0; n2 < this.lindep.length; ++n2) {
            if (this.lindep[n2]) continue;
            ++n5;
        }
        n2 = 0;
        for (int i = 0; i < this.nvars; ++i) {
            if (this.vorder[i] == nArray2[i]) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            return new RegressionResults(dArray, new double[][]{dArray2}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
        }
        double[] dArray3 = new double[dArray.length];
        int[] nArray3 = new int[dArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            for (n = 0; n < this.vorder.length; ++n) {
                if (this.vorder[n] != nArray2[i]) continue;
                dArray3[i] = dArray[n];
                nArray3[i] = n;
            }
        }
        double[] dArray4 = new double[dArray2.length];
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            int n6 = nArray3[i];
            int n7 = 0;
            while (n7 <= i) {
                int n8 = nArray3[n7];
                int n9 = n6 > n8 ? n6 * (n6 + 1) / 2 + n8 : n8 * (n8 + 1) / 2 + n6;
                dArray4[n] = dArray2[n9];
                ++n7;
                ++n;
            }
        }
        return new RegressionResults(dArray3, new double[][]{dArray4}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
    }
}

