/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;

public class TransformUtils {
    private static final int[] POWERS_OF_TWO = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};

    private TransformUtils() {
    }

    public static double[] scaleArray(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return dArray;
    }

    public static Complex[] scaleArray(Complex[] complexArray, double d) {
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = new Complex(d * complexArray[i].getReal(), d * complexArray[i].getImaginary());
        }
        return complexArray;
    }

    public static double[][] createRealImaginaryArray(Complex[] complexArray) {
        double[][] dArray = new double[2][complexArray.length];
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        for (int i = 0; i < complexArray.length; ++i) {
            Complex complex = complexArray[i];
            dArray2[i] = complex.getReal();
            dArray3[i] = complex.getImaginary();
        }
        return dArray;
    }

    public static Complex[] createComplexArray(double[][] dArray) {
        if (dArray.length != 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        if (dArray2.length != dArray3.length) {
            throw new DimensionMismatchException(dArray3.length, dArray2.length);
        }
        int n = dArray2.length;
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = new Complex(dArray2[i], dArray3[i]);
        }
        return complexArray;
    }

    public static int exactLog2(int n) {
        int n2 = Arrays.binarySearch(POWERS_OF_TWO, n);
        if (n2 < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, n);
        }
        return n2;
    }
}

