/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.NumberTransformer;

public class DefaultTransformer
implements NumberTransformer,
Serializable {
    private static final long serialVersionUID = 4019938025047800455L;

    public double transform(Object object) {
        if (object == null) {
            throw new NullArgumentException(LocalizedFormats.OBJECT_TRANSFORMATION, new Object[0]);
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_TRANSFORM_TO_DOUBLE, object.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof DefaultTransformer;
    }

    public int hashCode() {
        return 401993047;
    }
}

