/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.IntegerSequence;

@Deprecated
public class Incrementor {
    private int maximalCount;
    private int count = 0;
    private final MaxCountExceededCallback maxCountCallback;

    public Incrementor() {
        this(0);
    }

    public Incrementor(int n) {
        this(n, new MaxCountExceededCallback(){

            public void trigger(int n) {
                throw new MaxCountExceededException(n);
            }
        });
    }

    public Incrementor(int n, MaxCountExceededCallback maxCountExceededCallback) {
        if (maxCountExceededCallback == null) {
            throw new NullArgumentException();
        }
        this.maximalCount = n;
        this.maxCountCallback = maxCountExceededCallback;
    }

    public void setMaximalCount(int n) {
        this.maximalCount = n;
    }

    public int getMaximalCount() {
        return this.maximalCount;
    }

    public int getCount() {
        return this.count;
    }

    public boolean canIncrement() {
        return this.count < this.maximalCount;
    }

    public void incrementCount(int n) {
        for (int i = 0; i < n; ++i) {
            this.incrementCount();
        }
    }

    public void incrementCount() {
        if (++this.count > this.maximalCount) {
            this.maxCountCallback.trigger(this.maximalCount);
        }
    }

    public void resetCount() {
        this.count = 0;
    }

    public static Incrementor wrap(final IntegerSequence.Incrementor incrementor) {
        return new Incrementor(){
            private IntegerSequence.Incrementor delegate;
            {
                this.delegate = incrementor;
                super.setMaximalCount(this.delegate.getMaximalCount());
                super.incrementCount(this.delegate.getCount());
            }

            public void setMaximalCount(int n) {
                super.setMaximalCount(n);
                this.delegate = this.delegate.withMaximalCount(n);
            }

            public void resetCount() {
                super.resetCount();
                this.delegate = this.delegate.withStart(0);
            }

            public void incrementCount() {
                super.incrementCount();
                this.delegate.increment();
            }
        };
    }

    public static interface MaxCountExceededCallback {
        public void trigger(int var1) throws MaxCountExceededException;
    }
}

