/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIntToFieldHashMap<T extends FieldElement<T>>
implements Serializable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final long serialVersionUID = -9179080286849120720L;
    private static final float LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_EXPECTED_SIZE = 16;
    private static final int RESIZE_MULTIPLIER = 2;
    private static final int PERTURB_SHIFT = 5;
    private final Field<T> field;
    private int[] keys;
    private T[] values;
    private byte[] states;
    private final T missingEntries;
    private int size;
    private int mask;
    private transient int count;

    public OpenIntToFieldHashMap(Field<T> field) {
        this(field, 16, (FieldElement)field.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field, T t) {
        this(field, 16, t);
    }

    public OpenIntToFieldHashMap(Field<T> field, int n) {
        this(field, n, (FieldElement)field.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field, int n, T t) {
        this.field = field;
        int n2 = OpenIntToFieldHashMap.computeCapacity(n);
        this.keys = new int[n2];
        this.values = this.buildArray(n2);
        this.states = new byte[n2];
        this.missingEntries = t;
        this.mask = n2 - 1;
    }

    public OpenIntToFieldHashMap(OpenIntToFieldHashMap<T> openIntToFieldHashMap) {
        this.field = openIntToFieldHashMap.field;
        int n = openIntToFieldHashMap.keys.length;
        this.keys = new int[n];
        System.arraycopy(openIntToFieldHashMap.keys, 0, this.keys, 0, n);
        this.values = this.buildArray(n);
        System.arraycopy(openIntToFieldHashMap.values, 0, this.values, 0, n);
        this.states = new byte[n];
        System.arraycopy(openIntToFieldHashMap.states, 0, this.states, 0, n);
        this.missingEntries = openIntToFieldHashMap.missingEntries;
        this.size = openIntToFieldHashMap.size;
        this.mask = openIntToFieldHashMap.mask;
        this.count = openIntToFieldHashMap.count;
    }

    private static int computeCapacity(int n) {
        if (n == 0) {
            return 1;
        }
        int n2 = (int)FastMath.ceil((float)n / 0.5f);
        int n3 = Integer.highestOneBit(n2);
        if (n3 == n2) {
            return n2;
        }
        return OpenIntToFieldHashMap.nextPowerOfTwo(n2);
    }

    private static int nextPowerOfTwo(int n) {
        return Integer.highestOneBit(n) << 1;
    }

    public T get(int n) {
        int n2 = OpenIntToFieldHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return this.values[n3];
        }
        if (this.states[n3] == 0) {
            return this.missingEntries;
        }
        int n4 = n3;
        int n5 = OpenIntToFieldHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToFieldHashMap.probe(n5, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return this.values[n3];
            }
            n5 >>= 5;
        }
        return this.missingEntries;
    }

    public boolean containsKey(int n) {
        int n2 = OpenIntToFieldHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return true;
        }
        if (this.states[n3] == 0) {
            return false;
        }
        int n4 = n3;
        int n5 = OpenIntToFieldHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToFieldHashMap.probe(n5, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return true;
            }
            n5 >>= 5;
        }
        return false;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    private static int perturb(int n) {
        return n & Integer.MAX_VALUE;
    }

    private int findInsertionIndex(int n) {
        return OpenIntToFieldHashMap.findInsertionIndex(this.keys, this.states, n, this.mask);
    }

    private static int findInsertionIndex(int[] nArray, byte[] byArray, int n, int n2) {
        int n3 = OpenIntToFieldHashMap.hashOf(n);
        int n4 = n3 & n2;
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1 && nArray[n4] == n) {
            return OpenIntToFieldHashMap.changeIndexSign(n4);
        }
        int n5 = OpenIntToFieldHashMap.perturb(n3);
        int n6 = n4;
        if (byArray[n4] == 1) {
            do {
                n6 = OpenIntToFieldHashMap.probe(n5, n6);
                n4 = n6 & n2;
                n5 >>= 5;
            } while (byArray[n4] == 1 && nArray[n4] != n);
        }
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1) {
            return OpenIntToFieldHashMap.changeIndexSign(n4);
        }
        int n7 = n4;
        while (byArray[n4 = (n6 = OpenIntToFieldHashMap.probe(n5, n6)) & n2] != 0) {
            if (byArray[n4] == 1 && nArray[n4] == n) {
                return OpenIntToFieldHashMap.changeIndexSign(n4);
            }
            n5 >>= 5;
        }
        return n7;
    }

    private static int probe(int n, int n2) {
        return (n2 << 2) + n2 + n + 1;
    }

    private static int changeIndexSign(int n) {
        return -n - 1;
    }

    public int size() {
        return this.size;
    }

    public T remove(int n) {
        int n2 = OpenIntToFieldHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return this.doRemove(n3);
        }
        if (this.states[n3] == 0) {
            return this.missingEntries;
        }
        int n4 = n3;
        int n5 = OpenIntToFieldHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToFieldHashMap.probe(n5, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return this.doRemove(n3);
            }
            n5 >>= 5;
        }
        return this.missingEntries;
    }

    private boolean containsKey(int n, int n2) {
        return (n != 0 || this.states[n2] == 1) && this.keys[n2] == n;
    }

    private T doRemove(int n) {
        this.keys[n] = 0;
        this.states[n] = 2;
        T t = this.values[n];
        this.values[n] = this.missingEntries;
        --this.size;
        ++this.count;
        return t;
    }

    public T put(int n, T t) {
        int n2 = this.findInsertionIndex(n);
        T t2 = this.missingEntries;
        boolean bl = true;
        if (n2 < 0) {
            n2 = OpenIntToFieldHashMap.changeIndexSign(n2);
            t2 = this.values[n2];
            bl = false;
        }
        this.keys[n2] = n;
        this.states[n2] = 1;
        this.values[n2] = t;
        if (bl) {
            ++this.size;
            if (this.shouldGrowTable()) {
                this.growTable();
            }
            ++this.count;
        }
        return t2;
    }

    private void growTable() {
        int n = this.states.length;
        int[] nArray = this.keys;
        T[] TArray = this.values;
        byte[] byArray = this.states;
        int n2 = 2 * n;
        int[] nArray2 = new int[n2];
        FieldElement[] fieldElementArray = this.buildArray(n2);
        byte[] byArray2 = new byte[n2];
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 1) continue;
            int n4 = nArray[i];
            int n5 = OpenIntToFieldHashMap.findInsertionIndex(nArray2, byArray2, n4, n3);
            nArray2[n5] = n4;
            fieldElementArray[n5] = TArray[i];
            byArray2[n5] = 1;
        }
        this.mask = n3;
        this.keys = nArray2;
        this.values = fieldElementArray;
        this.states = byArray2;
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    private static int hashOf(int n) {
        int n2 = n ^ (n >>> 20 ^ n >>> 12);
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.count = 0;
    }

    private T[] buildArray(int n) {
        return (FieldElement[])Array.newInstance(this.field.getRuntimeClass(), n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator {
        private final int referenceCount;
        private int current;
        private int next;

        private Iterator() {
            this.referenceCount = OpenIntToFieldHashMap.this.count;
            this.next = -1;
            try {
                this.advance();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int key() {
            if (this.referenceCount != OpenIntToFieldHashMap.this.count) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            return OpenIntToFieldHashMap.this.keys[this.current];
        }

        public T value() {
            if (this.referenceCount != OpenIntToFieldHashMap.this.count) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new NoSuchElementException();
            }
            return OpenIntToFieldHashMap.this.values[this.current];
        }

        public void advance() {
            block4: {
                if (this.referenceCount != OpenIntToFieldHashMap.this.count) {
                    throw new ConcurrentModificationException();
                }
                this.current = this.next;
                try {
                    while (OpenIntToFieldHashMap.this.states[++this.next] != 1) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.next = -2;
                    if (this.current >= 0) break block4;
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

