/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.command.CmdSell;
import net.brcdev.shopgui.command.CmdShop;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.core.BConfig;
import net.brcdev.shopgui.database.DataManager;
import net.brcdev.shopgui.database.MySqlDataManager;
import net.brcdev.shopgui.database.SqliteDataManager;
import net.brcdev.shopgui.economy.EconomyManager;
import net.brcdev.shopgui.event.ShopGUIPlusPostEnableEvent;
import net.brcdev.shopgui.item.ItemManager;
import net.brcdev.shopgui.listener.PlayerListener;
import net.brcdev.shopgui.modifier.PriceModifierManager;
import net.brcdev.shopgui.player.PlayerManager;
import net.brcdev.shopgui.provider.language.LanguageLanguageUtilsProvider;
import net.brcdev.shopgui.provider.language.LanguageProvider;
import net.brcdev.shopgui.settings.MenuSettingsValidator;
import net.brcdev.shopgui.shop.ShopFileManager;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.sound.SoundManager;
import net.brcdev.shopgui.spawner.SpawnerManager;
import net.brcdev.shopgui.task.LoadShopsTask;
import net.brcdev.shopgui.util.Constants;
import net.brcdev.shopgui.util.FileUtils;
import net.brcdev.shopgui.util.LogFormatter;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopGuiPlugin
extends JavaPlugin {
    private static ShopGuiPlugin instance;
    private BConfig configMain;
    private BConfig configLang;
    private BConfig configPriceModifiers;
    private CmdSell cmdSell;
    private CmdShop cmdShop;
    private DataManager dataManager;
    private EconomyManager economyManager;
    private ItemManager itemManager;
    private PlayerManager playerManager;
    private PriceModifierManager priceModifierManager;
    private ShopFileManager shopFileManager;
    private ShopManager shopManager;
    private SpawnerManager spawnerManager;
    private SoundManager soundManager;
    private MenuSettingsValidator menuSettingsValidator;
    private LanguageProvider languageProvider;
    private int loadShopsTaskId = -1;
    private Permission permissions;
    private Logger logger;
    private Logger fileLogger;
    private FileHandler handler;
    private Gson gson;

    public static ShopGuiPlugin getInstance() {
        return instance;
    }

    public BConfig getConfigMain() {
        return this.configMain;
    }

    public BConfig getConfigLang() {
        return this.configLang;
    }

    public BConfig getConfigPriceModifiers() {
        return this.configPriceModifiers;
    }

    public CmdSell getCmdSell() {
        return this.cmdSell;
    }

    public CmdShop getCmdShop() {
        return this.cmdShop;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public PriceModifierManager getPriceModifierManager() {
        return this.priceModifierManager;
    }

    public ShopFileManager getShopFileManager() {
        return this.shopFileManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public LanguageProvider getLanguageProvider() {
        return this.languageProvider;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void onEnable() {
        ShopGuiPlugin.loadConfig0();
        instance = this;
        ShopGuiPlusApi.setPlugin(this);
        this.logger = this.getLogger();
        this.fileLogger = Logger.getLogger(Constants.LOGGER_FILE_NAME);
        this.gson = new Gson();
        this.init();
        this.load();
        this.initLogger();
        switch (Settings.databaseType) {
            case MYSQL: {
                this.dataManager = new MySqlDataManager(this);
                break;
            }
            case SQLITE: {
                this.dataManager = new SqliteDataManager(this);
            }
        }
        this.dataManager.open();
        this.dataManager.setup();
        this.itemManager.registerDefaultItemProviders();
        this.cmdSell = new CmdSell(this);
        this.cmdShop = new CmdShop(this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getCommand("sell").setExecutor((CommandExecutor)this.cmdSell);
        this.getCommand("shop").setExecutor((CommandExecutor)this.cmdShop);
    }

    private void init() {
        this.shopFileManager = new ShopFileManager(this);
        this.shopManager = new ShopManager(this);
        this.economyManager = new EconomyManager(this);
        this.itemManager = new ItemManager(this);
        this.playerManager = new PlayerManager(this);
        this.priceModifierManager = new PriceModifierManager(this);
        this.spawnerManager = new SpawnerManager(this);
        this.soundManager = new SoundManager(this);
        this.menuSettingsValidator = new MenuSettingsValidator(this);
    }

    public void load() {
        this.loadConfigFiles();
        Lang.setConfig(this.configLang);
        Settings.setConfig(this.configMain);
        Settings.load();
        this.loadShopsTaskId = Bukkit.getScheduler().runTaskTimer((Plugin)this, (Runnable)new LoadShopsTask(this), 1L, 20L).getTaskId();
    }

    public void loadAfterServerLoaded() {
        Bukkit.getPluginManager().callEvent((Event)new ShopGUIPlusPostEnableEvent());
        this.cancelShopsLoadTask();
        this.printLogHeader();
        if (!this.economyManager.setup()) {
            return;
        }
        this.setupPermissions();
        this.setupLanguage();
        this.itemManager.setup();
        this.spawnerManager.setup();
        Settings.loadItemStacks();
        if (!this.menuSettingsValidator.validateMenus()) {
            this.gracefullyDisablePlugin();
            return;
        }
        this.shopFileManager.loadDefaultShopConfigs();
        this.shopManager.load();
        this.priceModifierManager.loadPriceModifiers();
        this.soundManager.loadSounds();
        this.printLogFooter();
    }

    private void printLogHeader() {
        this.info("================================[ ShopGUI+ " + this.getDescription().getVersion() + " ]================================");
        this.info(" ");
    }

    private void printLogFooter() {
        this.info(" ");
        this.info("====================================================================================");
    }

    private void gracefullyDisablePlugin() {
        this.printLogFooter();
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    private void loadConfigFiles() {
        String string = "";
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_14)) {
            string = "config/1_14-1_19.yml";
        } else if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_13)) {
            string = "config/1_13.yml";
        } else if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9)) {
            string = "config/1_9-1_12.yml";
        } else if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_7)) {
            string = "config/1_7-1_8.yml";
        }
        this.configMain = new BConfig(this, "config.yml", string);
        this.configLang = new BConfig(this, "lang.yml");
        this.configPriceModifiers = new BConfig(this, "pricemodifiers.yml");
    }

    public void initLogger() {
        if (Settings.logToFile) {
            File file = FileUtils.loadFile("shop.log");
            FileHandler fileHandler = null;
            try {
                fileHandler = new FileHandler(file.getAbsolutePath(), true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            fileHandler.setFormatter(new LogFormatter());
            this.handler = fileHandler;
            this.fileLogger.addHandler(fileHandler);
            this.fileLogger.setUseParentHandlers(false);
        }
    }

    public void onDisable() {
        if (this.handler != null) {
            for (Handler handler : this.fileLogger.getHandlers()) {
                handler.close();
                this.fileLogger.removeHandler(handler);
            }
        }
    }

    public void severe(String string) {
        this.logger.severe(string);
    }

    public void warning(String string) {
        this.logger.warning(string);
    }

    public void info(String string) {
        this.logger.info(string);
    }

    public void log(String string) {
        this.logger.info(string);
    }

    public void logTransaction(String string) {
        if (Settings.logToFile) {
            this.fileLogger.info(string);
        }
        if (Settings.logToConsole) {
            this.logger.info(string);
        }
    }

    private void setupLanguage() {
        String string = "";
        if (this.getServer().getPluginManager().getPlugin(Constants.PLUGIN_LANGUTILS) != null) {
            string = Constants.PLUGIN_LANGUTILS;
            this.languageProvider = new LanguageLanguageUtilsProvider();
        }
        if (this.enableLanguage()) {
            this.info(string + " support enabled.");
        }
    }

    public boolean enableLanguage() {
        return this.languageProvider != null;
    }

    private void setupPermissions() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        this.permissions = (Permission)registeredServiceProvider.getProvider();
        if (this.enablePermissions()) {
            this.info("Permissions support enabled.");
        } else {
            this.warning("Permissions plugin not found, permissions won't be supported.");
        }
    }

    public boolean enablePermissions() {
        return this.permissions != null;
    }

    private void cancelShopsLoadTask() {
        Bukkit.getScheduler().cancelTask(this.loadShopsTaskId);
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=469039&resource_id=6515&nonce=1964183851").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

