/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.database;

import com.google.gson.reflect.TypeToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.modifier.command.CommandPriceModifiers;
import net.brcdev.shopgui.player.PlayerData;
import org.bukkit.entity.Player;

public abstract class DataManager {
    protected ShopGuiPlugin main;
    protected String playersTableName;
    protected String fileBackendName = "database";
    protected Connection connection = null;
    protected ExecutorService executorService = null;
    private long lastValidation;

    public DataManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.playersTableName = Settings.databaseTableNamePlayers;
        this.executorService = Executors.newFixedThreadPool(1);
        this.lastValidation = System.currentTimeMillis();
    }

    public abstract void setup();

    public abstract void open();

    public void close() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return;
            }
            this.connection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.open();
            }
            if (System.currentTimeMillis() - this.lastValidation >= 5000L) {
                PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT 1");
                preparedStatement.executeQuery();
                this.lastValidation = System.currentTimeMillis();
            }
        }
        catch (SQLException sQLException) {
            this.open();
        }
        return this.connection;
    }

    public void executeQuery(String string) {
        this.executorService.submit(() -> {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.getConnection().prepareStatement(string);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        });
    }

    protected PlayerData getPlayerDataFromResult(ResultSet resultSet) {
        CommandPriceModifiers commandPriceModifiers = (CommandPriceModifiers)this.main.getGson().fromJson(resultSet.getString("priceModifiers"), new TypeToken<CommandPriceModifiers>(){}.getType());
        return new PlayerData(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("name"), commandPriceModifiers);
    }

    public void loadPlayerData(Player player, Callback<PlayerData> callback) {
        this.executorService.submit(() -> {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string = "SELECT * FROM " + this.playersTableName + " WHERE uuid='" + player.getUniqueId().toString() + "'";
                statement = this.getConnection().prepareStatement(string);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) {
                    callback.onSuccess(this.main.getPlayerManager().registerPlayer(player));
                    return;
                }
                callback.onSuccess(this.getPlayerDataFromResult(resultSet));
            }
            catch (SQLException sQLException) {
                callback.onFailure(null);
                sQLException.printStackTrace();
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        });
    }

    public void retrievePlayerData(String string, Callback<PlayerData> callback) {
        this.executorService.submit(() -> {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.getConnection().prepareStatement("SELECT * FROM " + this.playersTableName + " WHERE name='" + string + "'");
                resultSet = statement.executeQuery();
                if (!resultSet.next()) {
                    callback.onSuccess(null);
                    return;
                }
                callback.onSuccess(this.getPlayerDataFromResult(resultSet));
            }
            catch (SQLException sQLException) {
                callback.onFailure(null);
                sQLException.printStackTrace();
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        });
    }

    public void registerPlayerData(PlayerData playerData) {
        this.executeQuery("INSERT INTO " + this.playersTableName + "(uuid, name, priceModifiers) VALUES ('" + playerData.getId().toString() + "', '" + playerData.getName() + "', '" + this.main.getGson().toJson(playerData.getPriceModifiers()) + "');");
    }

    public void savePlayerData(PlayerData playerData) {
        this.executeQuery("UPDATE " + this.playersTableName + " SET name='" + playerData.getName() + "', priceModifiers='" + this.main.getGson().toJson(playerData.getPriceModifiers()) + "' WHERE uuid='" + playerData.getId().toString() + "';");
    }

    public static enum DatabaseType {
        MYSQL,
        SQLITE;

    }
}

