/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.gui.element;

import java.util.ArrayList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class GuiElement {
    protected ItemStack itemStack;
    protected ItemStack placeholderItemStack;
    protected ItemStack fillItem;

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getPlaceholderItemStack() {
        if (this.placeholderItemStack == null) {
            this.placeholderItemStack = this.itemStack.clone();
        }
        return this.placeholderItemStack;
    }

    public void setPlaceholderItemStack(ItemStack itemStack) {
        this.placeholderItemStack = itemStack;
    }

    public ItemStack getFillItem() {
        return this.fillItem;
    }

    public void setFillItem(ItemStack itemStack) {
        this.fillItem = itemStack;
    }

    public GuiElement replacePlaceholder(String string, String string2) {
        return this.replaceNamePlaceholder(string, string2).replaceLorePlaceholder(string, string2);
    }

    public GuiElement replaceNamePlaceholder(String string, String string2) {
        ItemMeta itemMeta = this.getPlaceholderItemStack().getItemMeta();
        if (itemMeta.hasDisplayName()) {
            itemMeta.setDisplayName(itemMeta.getDisplayName().replace(string, string2));
            this.getPlaceholderItemStack().setItemMeta(itemMeta);
        }
        return this;
    }

    public GuiElement replaceLorePlaceholder(String string, String string2) {
        ItemMeta itemMeta = this.getPlaceholderItemStack().getItemMeta();
        if (itemMeta.hasLore()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string3 : itemMeta.getLore()) {
                arrayList.add(string3.replace(string, string2));
            }
            itemMeta.setLore(arrayList);
            this.getPlaceholderItemStack().setItemMeta(itemMeta);
        }
        return this;
    }

    public GuiElement replaceFromItem(ItemStack itemStack) {
        ItemStack itemStack2 = itemStack.clone();
        ItemMeta itemMeta = itemStack2.getItemMeta();
        if (this.getPlaceholderItemStack().hasItemMeta()) {
            if (this.getPlaceholderItemStack().getItemMeta().hasDisplayName()) {
                itemMeta.setDisplayName(this.getPlaceholderItemStack().getItemMeta().getDisplayName());
            }
            if (this.getPlaceholderItemStack().getItemMeta().hasLore()) {
                itemMeta.setLore(this.getPlaceholderItemStack().getItemMeta().getLore());
            }
        }
        itemStack2.setItemMeta(itemMeta);
        itemStack2.setAmount(this.getPlaceholderItemStack().getAmount());
        this.placeholderItemStack = itemStack2;
        return this;
    }
}

