/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.modifier;

import java.util.Map;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.modifier.PriceModifierActionType;

public class PriceModifierEntry {
    private Map<PriceModifierActionType, Double> modifiers;

    public PriceModifierEntry(Map<PriceModifierActionType, Double> map) {
        this.modifiers = map;
    }

    public double get(PriceModifierActionType priceModifierActionType) {
        return this.modifiers.containsKey((Object)priceModifierActionType) ? this.modifiers.get((Object)priceModifierActionType) : 1.0;
    }

    public void set(PriceModifierActionType priceModifierActionType, double d) {
        if (priceModifierActionType == PriceModifierActionType.BOTH) {
            this.modifiers.put(PriceModifierActionType.BUY, d);
            this.modifiers.put(PriceModifierActionType.SELL, d);
        } else {
            this.modifiers.put(priceModifierActionType, d);
        }
    }

    public void reset(PriceModifierActionType priceModifierActionType) {
        this.modifiers.remove((Object)priceModifierActionType);
    }

    public boolean isPrimary() {
        for (double d : this.modifiers.values()) {
            if (d == 1.0) continue;
            return false;
        }
        return true;
    }

    public String formatPlaceholders(String string) {
        String string2 = "";
        if (this.modifiers.containsKey((Object)PriceModifierActionType.BUY)) {
            string2 = Settings.formatModifierString(this.modifiers.get((Object)PriceModifierActionType.BUY));
        }
        String string3 = "";
        if (this.modifiers.containsKey((Object)PriceModifierActionType.SELL)) {
            string3 = Settings.formatModifierString(this.modifiers.get((Object)PriceModifierActionType.SELL));
        }
        return string.replace("%buy%", string2).replace("%sell%", string3);
    }
}

