/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.modifier.command;

import java.util.HashMap;
import java.util.Map;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.modifier.PriceModifierEntry;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;

public class CommandPriceModifiers {
    private PriceModifierEntry globalModifier;
    private Map<String, PriceModifierEntry> shopModifiers;
    private Map<String, Map<String, PriceModifierEntry>> itemModifiers;

    public CommandPriceModifiers(PriceModifierEntry priceModifierEntry, Map<String, PriceModifierEntry> map, Map<String, Map<String, PriceModifierEntry>> map2) {
        this.globalModifier = priceModifierEntry;
        this.shopModifiers = map;
        this.itemModifiers = map2;
    }

    public PriceModifierEntry getGlobalModifier() {
        return this.globalModifier;
    }

    public Map<String, PriceModifierEntry> getShopModifiers() {
        return this.shopModifiers;
    }

    public Map<String, Map<String, PriceModifierEntry>> getItemModifiers() {
        return this.itemModifiers;
    }

    public double getItemModifier(ShopItem shopItem, PriceModifierActionType priceModifierActionType) {
        Shop shop = shopItem.getShop();
        if (this.itemModifiers.containsKey(shop.getId()) && this.itemModifiers.get(shop.getId()).containsKey(shopItem.getId())) {
            return this.itemModifiers.get(shop.getId()).get(shopItem.getId()).get(priceModifierActionType);
        }
        if (this.shopModifiers.containsKey(shop.getId())) {
            return this.shopModifiers.get(shop.getId()).get(priceModifierActionType);
        }
        return this.globalModifier.get(priceModifierActionType);
    }

    public void setItemModifier(ShopItem shopItem, PriceModifierActionType priceModifierActionType, double d) {
        Shop shop = shopItem.getShop();
        if (!this.itemModifiers.containsKey(shop.getId())) {
            this.itemModifiers.put(shop.getId(), new HashMap());
        }
        if (!this.itemModifiers.get(shop.getId()).containsKey(shopItem.getId())) {
            this.itemModifiers.get(shop.getId()).put(shopItem.getId(), new PriceModifierEntry(new HashMap<PriceModifierActionType, Double>()));
        }
        this.itemModifiers.get(shop.getId()).get(shopItem.getId()).set(priceModifierActionType, d);
    }

    public void resetItemModifier(ShopItem shopItem, PriceModifierActionType priceModifierActionType) {
        Shop shop = shopItem.getShop();
        if (this.itemModifiers.containsKey(shop.getId()) && this.itemModifiers.get(shop.getId()).containsKey(shopItem.getId())) {
            this.itemModifiers.get(shop.getId()).get(shopItem.getId()).set(priceModifierActionType, 1.0);
            if (this.itemModifiers.get(shop.getId()).get(shopItem.getId()).isPrimary()) {
                this.itemModifiers.get(shop.getId()).remove(shopItem.getId());
            }
        }
    }

    public double getShopModifier(Shop shop, PriceModifierActionType priceModifierActionType) {
        if (this.shopModifiers.containsKey(shop.getId())) {
            return this.shopModifiers.get(shop.getId()).get(priceModifierActionType);
        }
        return this.globalModifier.get(priceModifierActionType);
    }

    public void setShopModifier(Shop shop, PriceModifierActionType priceModifierActionType, double d) {
        if (!this.shopModifiers.containsKey(shop.getId())) {
            this.shopModifiers.put(shop.getId(), new PriceModifierEntry(new HashMap<PriceModifierActionType, Double>()));
        }
        this.shopModifiers.get(shop.getId()).set(priceModifierActionType, d);
    }

    public void resetShopModifier(Shop shop, PriceModifierActionType priceModifierActionType) {
        if (this.shopModifiers.containsKey(shop.getId())) {
            this.shopModifiers.get(shop.getId()).set(priceModifierActionType, 1.0);
            if (this.shopModifiers.get(shop.getId()).isPrimary()) {
                this.shopModifiers.remove(shop.getId());
            }
        }
    }

    public double getGlobalModifier(PriceModifierActionType priceModifierActionType) {
        return this.globalModifier.get(priceModifierActionType);
    }

    public void setGlobalModifier(PriceModifierActionType priceModifierActionType, double d) {
        this.globalModifier.set(priceModifierActionType, d);
    }

    public void resetGlobalModifier(PriceModifierActionType priceModifierActionType) {
        this.globalModifier.set(priceModifierActionType, 1.0);
    }
}

