/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.nbt;

import java.util.List;
import net.brcdev.shopgui.exception.item.nbt.InvalidNbtTagTypeException;
import net.brcdev.shopgui.exception.item.nbt.InvalidNbtTagValueException;
import net.brcdev.shopgui.exception.item.nbt.MissingNbtTagKeyException;
import net.brcdev.shopgui.exception.item.nbt.MissingNbtTagValueException;
import net.brcdev.shopgui.exception.item.nbt.NbtTagSetException;
import net.brcdev.shopgui.nbt.NbtTagType;
import net.brcdev.shopgui.util.NumberUtils;
import org.bukkit.configuration.ConfigurationSection;
import shaded.de.tr7zw.changeme.nbtapi.NBTCompound;
import shaded.de.tr7zw.changeme.nbtapi.NBTList;
import shaded.de.tr7zw.changeme.nbtapi.NbtApiException;

public class NbtTagLoader {
    public static void loadNbt(NBTCompound nBTCompound, String string, ConfigurationSection configurationSection) {
        for (String string2 : configurationSection.getKeys(false)) {
            NbtTagLoader.loadNbtTag(nBTCompound, string, configurationSection, string2);
        }
    }

    private static void loadNbtTag(NBTCompound nBTCompound, String string, ConfigurationSection configurationSection, String string2) {
        NbtTagType nbtTagType;
        String string3;
        if (string != null) {
            nBTCompound = nBTCompound.getCompound(string);
        }
        if ((string3 = (configurationSection = configurationSection.getConfigurationSection(string2)).getString("type")) == null) {
            throw new InvalidNbtTagTypeException();
        }
        string3 = string3.toUpperCase();
        try {
            nbtTagType = NbtTagType.valueOf(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidNbtTagTypeException();
        }
        String string4 = configurationSection.getString("key");
        if (string4 == null) {
            throw new MissingNbtTagKeyException();
        }
        if (configurationSection.get(nbtTagType.getValuePath()) == null) {
            throw new MissingNbtTagValueException();
        }
        String string5 = configurationSection.getString(nbtTagType.getValuePath());
        try {
            switch (nbtTagType) {
                case BYTE: {
                    nBTCompound.setByte(string4, Byte.valueOf(string5));
                    break;
                }
                case SHORT: {
                    nBTCompound.setShort(string4, Short.valueOf(string5));
                    break;
                }
                case INT: {
                    nBTCompound.setInteger(string4, Integer.valueOf(string5));
                    break;
                }
                case LONG: {
                    nBTCompound.setLong(string4, Long.valueOf(string5));
                    break;
                }
                case FLOAT: {
                    nBTCompound.setFloat(string4, Float.valueOf(string5));
                    break;
                }
                case DOUBLE: {
                    nBTCompound.setDouble(string4, Double.valueOf(string5));
                    break;
                }
                case BYTE_ARRAY: {
                    nBTCompound.setByteArray(string4, string5.getBytes());
                    break;
                }
                case STRING: {
                    nBTCompound.setString(string4, string5);
                    break;
                }
                case STRING_ARRAY: {
                    nBTCompound.addCompound(string4);
                    List list = configurationSection.getStringList(nbtTagType.getValuePath());
                    ((NBTList)nBTCompound.getStringList(string4)).addAll(list);
                    break;
                }
                case COMPOUND: {
                    nBTCompound.addCompound(string4);
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(nbtTagType.getValuePath());
                    if (configurationSection2 == null) break;
                    NbtTagLoader.loadNbt(nBTCompound, string4, configurationSection2);
                    break;
                }
                case INT_ARRAY: {
                    nBTCompound.setIntArray(string4, NumberUtils.toIntArray(string5));
                }
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new InvalidNbtTagValueException();
        }
        catch (NbtApiException nbtApiException) {
            throw new NbtTagSetException();
        }
    }
}

