/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.provider.economy;

import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.util.Constants;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class EconomyCoinsEngineProvider
extends EconomyProvider {
    public EconomyCoinsEngineProvider() {
        this.currencyPrefix = "";
        this.currencySuffix = " coins";
    }

    @Override
    public String getName() {
        return Constants.PLUGIN_COINSENGINE;
    }

    @Override
    public double getBalance(Player player) {
        Currency currency = this.getDefaultCurrency();
        return currency == null ? 0.0 : CoinsEngineAPI.getBalance((Player)player, (Currency)currency);
    }

    @Override
    public void deposit(Player player, double d) {
        Currency currency = this.getDefaultCurrency();
        if (currency != null) {
            CoinsEngineAPI.addBalance((Player)player, (Currency)currency, (double)d);
        }
    }

    @Override
    public void withdraw(Player player, double d) {
        Currency currency = this.getDefaultCurrency();
        if (currency != null) {
            CoinsEngineAPI.removeBalance((Player)player, (Currency)currency, (double)d);
        }
    }

    @Nullable
    private Currency getDefaultCurrency() {
        return CoinsEngineAPI.getCurrency((String)"coins");
    }
}

