/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.util.FileUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopFileManager {
    private static final String YML_FILENAME_REGEX = ".*\\.yml";
    private static final String[] SHOP_FILES = new String[]{"armor.yml", "blocks.yml", "drops.yml", "dyes.yml", "farming.yml", "food.yml", "miscellaneous.yml", "ores.yml", "tools.yml"};
    private ShopGuiPlugin main;

    public ShopFileManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
    }

    public void loadDefaultShopConfigs() {
        if (this.doesLegacyConfigExist()) {
            return;
        }
        File file = this.getShopsDirectory();
        if (!file.exists() || !file.isDirectory()) {
            FileUtils.mkdir(file);
        }
        if (file.listFiles().length == 0) {
            this.copyShopConfigsFromJar();
        }
    }

    private void copyShopConfigsFromJar() {
        String string = "";
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_14)) {
            string = "1_14-1_19";
        } else if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_13)) {
            string = "1_13";
        } else if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_7)) {
            string = "1_7-1_12";
        }
        for (String string2 : SHOP_FILES) {
            FileUtils.copy(this.main.getResource("shops/" + string + "/" + string2), new File(this.getShopsDirectory(), string2));
        }
    }

    private File getShopsDirectory() {
        return new File(this.main.getDataFolder(), "shops/");
    }

    private File getLegacyShopsConfig() {
        return new File(this.main.getDataFolder(), "shops.yml");
    }

    private boolean doesShopsDirectoryExist() {
        return this.getShopsDirectory().exists();
    }

    private boolean doesLegacyConfigExist() {
        return this.getLegacyShopsConfig().exists();
    }

    private boolean isUsingLegacyShops() {
        return !this.doesShopsDirectoryExist();
    }

    public List<ConfigurationSection> getShopsConfigs() {
        ArrayList<ConfigurationSection> arrayList = new ArrayList<ConfigurationSection>();
        if (this.isUsingLegacyShops()) {
            arrayList.addAll(this.getShopsConfigSections(this.getLegacyShopsConfig(), true));
        } else {
            File file = this.getShopsDirectory();
            for (File file2 : file.listFiles()) {
                if (!file2.isFile() || !file2.getName().matches(YML_FILENAME_REGEX)) continue;
                arrayList.addAll(this.getShopsConfigSections(file2, false));
            }
        }
        return arrayList;
    }

    public ConfigurationSection getShopConfig(String string) {
        return this.getShopsConfigs().stream().filter(configurationSection -> configurationSection.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    private List<ConfigurationSection> getShopsConfigSections(File file, boolean bl) {
        ArrayList<ConfigurationSection> arrayList = new ArrayList<ConfigurationSection>();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (bl) {
            yamlConfiguration = yamlConfiguration.getConfigurationSection("shops");
        }
        if (yamlConfiguration != null) {
            yamlConfiguration.getKeys(false).stream().map(arg_0 -> ((ConfigurationSection)yamlConfiguration).getConfigurationSection(arg_0)).forEach(arrayList::add);
        }
        return arrayList;
    }
}

