/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;

public class ChatUtils {
    private static final Pattern HEX_COLOR_CODE_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");

    public static String fixColors(String string) {
        if (string == null) {
            return "";
        }
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_16)) {
            Matcher matcher = HEX_COLOR_CODE_PATTERN.matcher(string);
            while (matcher.find()) {
                String string2 = string.substring(matcher.start(), matcher.end());
                string = string.replace(string2, net.md_5.bungee.api.ChatColor.of((String)string2) + "");
                matcher = HEX_COLOR_CODE_PATTERN.matcher(string);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string).replace("\\n", "\n");
    }

    public static List<String> fixColors(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ChatUtils.fixColors(list.get(i)));
        }
        return list;
    }

    public static String formatCurrencyString(double d) {
        return ChatUtils.formatDoubleString(d);
    }

    public static String formatCurrencyString(Shop shop, double d) {
        return ChatUtils.formatCurrencyString(shop.getEconomyProvider(), d);
    }

    public static String formatCurrencyString(EconomyProvider economyProvider, double d) {
        return economyProvider.getCurrencyPrefix() + ChatUtils.formatDoubleString(d) + economyProvider.getCurrencySuffix();
    }

    public static String generateSuffix(int n) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(3, Lang.MSG_NUMBERFORMAT_SHORTSCALE_THOUSAND.toString());
        hashMap.put(6, Lang.MSG_NUMBERFORMAT_SHORTSCALE_MILLION.toString());
        hashMap.put(9, Lang.MSG_NUMBERFORMAT_SHORTSCALE_BILLION.toString());
        hashMap.put(12, Lang.MSG_NUMBERFORMAT_SHORTSCALE_TRILLION.toString());
        hashMap.put(15, Lang.MSG_NUMBERFORMAT_SHORTSCALE_QUADRILLION.toString());
        hashMap.put(18, Lang.MSG_NUMBERFORMAT_SHORTSCALE_QUINTILLION.toString());
        hashMap.put(21, Lang.MSG_NUMBERFORMAT_SHORTSCALE_SEXTILLION.toString());
        hashMap.put(24, Lang.MSG_NUMBERFORMAT_SHORTSCALE_SEPTILLION.toString());
        hashMap.put(27, Lang.MSG_NUMBERFORMAT_SHORTSCALE_OCTILLION.toString());
        hashMap.put(30, Lang.MSG_NUMBERFORMAT_SHORTSCALE_NONILLION.toString());
        hashMap.put(33, Lang.MSG_NUMBERFORMAT_SHORTSCALE_DECILLION.toString());
        return (String)hashMap.get(n);
    }

    public static String formatDoubleString(double d) {
        double d2 = Settings.parsePrice(d);
        if (Settings.numberFormatEnableShortScale && d2 >= (double)Settings.numberFormatShortScaleLimit) {
            int n = 0;
            for (int i = 33; i >= 3; i -= 3) {
                double d3 = d2 / Math.pow(10.0, i);
                if (!(d3 >= 1.0)) continue;
                n = i;
                break;
            }
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(Settings.numberFormatShortHandDecimalLimit);
            numberFormat.setMaximumIntegerDigits(Settings.numberFormatShortHandNumberLimit);
            return numberFormat.format(d2 / Math.pow(10.0, n)) + ChatUtils.generateSuffix(n);
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        decimalFormatSymbols.setDecimalSeparator(Settings.numberFormatDecimalSeparator.charAt(0));
        decimalFormatSymbols.setGroupingSeparator(Settings.numberFormatGroupingSeparator.charAt(0));
        String string = "###,###,##0.##";
        DecimalFormat decimalFormat = new DecimalFormat(string, decimalFormatSymbols);
        decimalFormat.setMinimumIntegerDigits(Settings.numberFormatMinimumIntegerDigits);
        decimalFormat.setMaximumIntegerDigits(Settings.numberFormatMaximumIntegerDigits);
        decimalFormat.setMinimumFractionDigits(Settings.numberFormatMinimumFractionDigits);
        decimalFormat.setMaximumFractionDigits(Settings.numberFormatMaximumFractionDigits);
        String string2 = decimalFormat.format(d2);
        if (Settings.numberFormatHideFraction && d2 % (double)((int)d2) == 0.0) {
            string2 = string2.split("\\.")[0];
        }
        return string2;
    }

    public static String formatEnchantmentName(Enchantment enchantment) {
        return enchantment.getName().toLowerCase().replace("_", " ");
    }

    public static String getValuesList(Class<? extends Enum> clazz) {
        Enum[] enumArray = clazz.getEnumConstants();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < enumArray.length; ++i) {
            stringBuilder.append(enumArray[i]);
            if (i >= enumArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

