/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.exception.item.InvalidDyeColorException;
import net.brcdev.shopgui.exception.item.InvalidEnchantmentException;
import net.brcdev.shopgui.exception.item.InvalidItemFlagException;
import net.brcdev.shopgui.exception.item.InvalidMaterialException;
import net.brcdev.shopgui.exception.item.InvalidModelException;
import net.brcdev.shopgui.exception.item.ItemLoadException;
import net.brcdev.shopgui.exception.item.MissingItemDefinitionException;
import net.brcdev.shopgui.exception.item.MissingSpawnEggTypeException;
import net.brcdev.shopgui.exception.item.PotionLoadException;
import net.brcdev.shopgui.exception.item.spawner.InvalidSpawnerEntityTypeException;
import net.brcdev.shopgui.legacy.LegacyItemStackHandler;
import net.brcdev.shopgui.nbt.NbtTagLoader;
import net.brcdev.shopgui.provider.item.ItemProvider;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.CollectionUtils;
import net.brcdev.shopgui.util.ColorUtils;
import net.brcdev.shopgui.util.EnchantmentNames;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import shaded.de.tr7zw.changeme.nbtapi.NBTCompound;
import shaded.de.tr7zw.changeme.nbtapi.NBTItem;

public class ItemUtils {
    private static final String[] MATERIALS_WITH_POTION_META = new String[]{"POTION", "LINGERING_POTION", "SPLASH_POTION", "TIPPED_ARROW"};
    private static final String[] MATERIALS_LEATHER = new String[]{"LEATHER_HELMET", "LEATHER_CHESTPLATE", "LEATHER_LEGGINGS", "LEATHER_BOOTS"};

    public static ItemStack loadSimpleItemStack(String string) {
        Material material;
        String[] stringArray = null;
        if (string.contains(":")) {
            stringArray = string.split(":");
        }
        String string2 = stringArray == null ? string : stringArray[0];
        string2 = string2.toUpperCase();
        try {
            material = Material.getMaterial((String)string2);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new InvalidMaterialException();
        }
        short s = 0;
        if (stringArray != null && stringArray.length >= 2) {
            try {
                s = Short.parseShort(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ItemStack(material, 1, s);
    }

    public static ItemStack loadItemStackFromConfig(ConfigurationSection configurationSection, String string) {
        ConfigurationSection configurationSection2 = configurationSection;
        if (!string.isEmpty()) {
            configurationSection2 = configurationSection.getConfigurationSection(string);
        }
        if (configurationSection2 == null) {
            throw new MissingItemDefinitionException();
        }
        int n = configurationSection2.getInt("quantity", 1);
        ItemStack itemStack = ShopGuiPlugin.getInstance().getItemManager().loadItem(configurationSection2);
        if (itemStack == null) {
            itemStack = ItemUtils.loadItemStack(configurationSection2, n);
        } else {
            itemStack.setAmount(n);
        }
        if (itemStack.getType() != Material.AIR) {
            itemStack = ItemUtils.loadSpawner(configurationSection2, itemStack);
            itemStack = ItemUtils.loadSpawnEgg(configurationSection2, itemStack);
            itemStack = ItemUtils.loadEnchantments(configurationSection2, itemStack);
            itemStack = ItemUtils.loadPlayerHeadMeta(configurationSection2, itemStack, n);
            itemStack = ItemUtils.loadColorMetaForLeatherItems(configurationSection2, itemStack);
            itemStack = ItemUtils.loadFireworkMeta(configurationSection2, itemStack);
            itemStack = ItemUtils.loadFireworkStarMeta(configurationSection2, itemStack);
            itemStack = ItemUtils.loadBannerMeta(configurationSection2, itemStack);
            itemStack = ItemUtils.loadShieldMeta(configurationSection2, itemStack);
            itemStack = ItemUtils.loadPotionMetaForPotionsAndArrows(configurationSection2, itemStack);
            itemStack = ItemUtils.loadItemMeta(configurationSection2, itemStack);
            itemStack = ItemUtils.loadItemNbtData(configurationSection2, itemStack);
            itemStack = ItemUtils.loadItemGlow(configurationSection2, itemStack);
        }
        return itemStack;
    }

    private static ItemStack loadSpawnEgg(ConfigurationSection configurationSection, ItemStack itemStack) {
        if (!ItemUtils.isSpawnEgg(itemStack)) {
            return itemStack;
        }
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && NmsUtils.isNmsVersionLowerThan(NmsVersion.v1_13)) {
            String string = configurationSection.getString("mob");
            if (StringUtils.isEmpty((String)string)) {
                throw new MissingSpawnEggTypeException();
            }
            if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_11)) {
                string = "minecraft:" + string;
            }
            NBTItem nBTItem = new NBTItem(itemStack);
            nBTItem.addCompound("EntityTag");
            NBTCompound nBTCompound = nBTItem.getCompound("EntityTag");
            nBTCompound.setString("id", string);
            if (configurationSection.getInt("mobType") != 0) {
                nBTCompound.setInteger("Type", configurationSection.getInt("mobType"));
            }
            return nBTItem.getItem();
        }
        return itemStack;
    }

    private static ItemStack loadPotionMetaForPotionsAndArrows(ConfigurationSection configurationSection, ItemStack itemStack) {
        PotionData potionData;
        if (!NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) || !ArrayUtils.contains((Object[])MATERIALS_WITH_POTION_META, (Object)itemStack.getType().name())) {
            return itemStack;
        }
        itemStack.setDurability((short)0);
        if (!configurationSection.contains("potion")) {
            return itemStack;
        }
        try {
            potionData = new PotionData(PotionType.valueOf((String)configurationSection.getString("potion.type", "INSTANT_HEAL").toUpperCase()), configurationSection.getBoolean("potion.extended", false), configurationSection.getInt("potion.level", 0) > 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PotionLoadException(illegalArgumentException.getMessage());
        }
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        potionMeta.setBasePotionData(potionData);
        Color color = ColorUtils.getColor(configurationSection.getString("potion.color"));
        if (color != null) {
            potionMeta.setColor(color);
        }
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }

    private static ItemStack loadPlayerHeadMeta(ConfigurationSection configurationSection, ItemStack itemStack, int n) {
        String string;
        if (!ItemUtils.isPlayerHead(itemStack)) {
            return itemStack;
        }
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_8) && StringUtils.isNotEmpty((String)(string = configurationSection.getString("skin")))) {
            itemStack = NmsUtils.setHeadSkin(itemStack, string);
        }
        if (StringUtils.isNotEmpty((String)(string = configurationSection.getString("skullOwner")))) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            skullMeta.setOwner(string);
            itemStack.setItemMeta((ItemMeta)skullMeta);
        }
        return itemStack;
    }

    private static ItemStack loadBannerMeta(ConfigurationSection configurationSection, ItemStack itemStack) {
        if (!NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_8)) {
            return itemStack;
        }
        if (!ItemUtils.isBanner(itemStack)) {
            return itemStack;
        }
        BannerMeta bannerMeta = (BannerMeta)itemStack.getItemMeta();
        bannerMeta.setBaseColor(ItemUtils.getDyeColor(configurationSection.getString("color", "BLACK")));
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("patterns");
        if (configurationSection2 == null) {
            return itemStack;
        }
        for (String string : configurationSection2.getKeys(false)) {
            PatternType patternType;
            DyeColor dyeColor;
            try {
                dyeColor = ItemUtils.getDyeColor(configurationSection2.getString(string + ".color", "BLACK"));
                patternType = PatternType.valueOf((String)configurationSection2.getString(string + ".type", "BASE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            bannerMeta.addPattern(new Pattern(dyeColor, patternType));
        }
        itemStack.setItemMeta((ItemMeta)bannerMeta);
        return itemStack;
    }

    private static ItemStack loadShieldMeta(ConfigurationSection configurationSection, ItemStack itemStack) {
        if (!NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9)) {
            return itemStack;
        }
        if (!ItemUtils.isShield(itemStack)) {
            return itemStack;
        }
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemStack.getItemMeta();
        if (!(blockStateMeta.getBlockState() instanceof Banner)) {
            return itemStack;
        }
        Banner banner = (Banner)blockStateMeta.getBlockState();
        banner.setBaseColor(ItemUtils.getDyeColor(configurationSection.getString("color", "BLACK")));
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("patterns");
        if (configurationSection2 == null) {
            return itemStack;
        }
        for (String string : configurationSection2.getKeys(false)) {
            PatternType patternType;
            DyeColor dyeColor;
            try {
                dyeColor = ItemUtils.getDyeColor(configurationSection2.getString(string + ".color", "BLACK"));
                patternType = PatternType.valueOf((String)configurationSection2.getString(string + ".type", "BASE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            banner.addPattern(new Pattern(dyeColor, patternType));
            banner.update();
        }
        blockStateMeta.setBlockState((BlockState)banner);
        itemStack.setItemMeta((ItemMeta)blockStateMeta);
        return itemStack;
    }

    private static ItemStack loadFireworkMeta(ConfigurationSection configurationSection, ItemStack itemStack) {
        if (!ItemUtils.isFirework(itemStack)) {
            return itemStack;
        }
        FireworkMeta fireworkMeta = (FireworkMeta)itemStack.getItemMeta();
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("fireworkEffects");
        if (configurationSection2 != null) {
            for (String string : configurationSection2.getKeys(false)) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                builder.with(FireworkEffect.Type.valueOf((String)configurationSection2.getString(string + ".type").toUpperCase()));
                if (CollectionUtils.isNotEmpty(configurationSection2.getStringList(string + ".colors"))) {
                    for (String string2 : configurationSection2.getStringList(string + ".colors")) {
                        builder.withColor(ItemUtils.getFireworkColor(string2));
                    }
                }
                if (CollectionUtils.isNotEmpty(configurationSection2.getStringList(string + ".fadeColors"))) {
                    for (String string2 : configurationSection2.getStringList(string + ".fadeColors")) {
                        builder.withFade(ItemUtils.getFireworkColor(string2));
                    }
                }
                if (configurationSection2.getBoolean(string + ".flicker")) {
                    builder.withFlicker();
                }
                if (configurationSection2.getBoolean(string + ".trail")) {
                    builder.withTrail();
                }
                fireworkMeta.addEffect(builder.build());
            }
        }
        if (configurationSection.getInt("fireworkPower") >= 1 && configurationSection.getInt("fireworkPower") <= 4) {
            fireworkMeta.setPower(configurationSection.getInt("fireworkPower"));
        }
        itemStack.setItemMeta((ItemMeta)fireworkMeta);
        return itemStack;
    }

    private static ItemStack loadFireworkStarMeta(ConfigurationSection configurationSection, ItemStack itemStack) {
        String string;
        if (!ItemUtils.isFireworkStar(itemStack)) {
            return itemStack;
        }
        FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemStack.getItemMeta();
        FireworkEffect.Builder builder = FireworkEffect.builder();
        String string2 = configurationSection.getString("fireworkColor");
        if (StringUtils.isNotEmpty((String)string2)) {
            builder.withColor(ItemUtils.getFireworkColor(string2));
        }
        if (StringUtils.isNotEmpty((String)(string = configurationSection.getString("fireworkFadeColor")))) {
            builder.withFade(ItemUtils.getFireworkColor(string));
        }
        try {
            fireworkEffectMeta.setEffect(builder.build());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        itemStack.setItemMeta((ItemMeta)fireworkEffectMeta);
        return itemStack;
    }

    private static ItemStack loadColorMetaForLeatherItems(ConfigurationSection configurationSection, ItemStack itemStack) {
        if (!ArrayUtils.contains((Object[])MATERIALS_LEATHER, (Object)itemStack.getType().name())) {
            return itemStack;
        }
        Color color = ColorUtils.getColor(configurationSection.getString("color"));
        if (color != null) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
            leatherArmorMeta.setColor(color);
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        return itemStack;
    }

    private static ItemStack loadEnchantments(ConfigurationSection configurationSection, ItemStack itemStack) {
        List list = configurationSection.getStringList("enchantments");
        if (CollectionUtils.isEmpty(list)) {
            return itemStack;
        }
        for (String string : list) {
            ItemUtils.loadEnchantment(itemStack, string);
        }
        return itemStack;
    }

    private static void loadEnchantment(ItemStack itemStack, String string) {
        int n;
        Enchantment enchantment;
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            return;
        }
        try {
            enchantment = EnchantmentNames.getEnchantment(stringArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidEnchantmentException();
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidEnchantmentException();
        }
        if (itemStack.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack.getItemMeta();
            enchantmentStorageMeta.addStoredEnchant(enchantment, n, true);
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            itemStack.addUnsafeEnchantment(enchantment, n);
        }
    }

    private static ItemStack loadItemStack(ConfigurationSection configurationSection, int n) {
        Material material = ItemUtils.loadMaterial(configurationSection);
        short s = Short.valueOf(configurationSection.getString("damage", "0"));
        return new ItemStack(material, n, s);
    }

    private static Material loadMaterial(ConfigurationSection configurationSection) {
        String string = configurationSection.getString("material");
        if (StringUtils.isEmpty((String)string)) {
            throw new InvalidMaterialException();
        }
        Material material = Material.getMaterial((String)string.toUpperCase());
        if (material == null) {
            throw new InvalidMaterialException();
        }
        return material;
    }

    private static ItemStack loadItemNbtData(ConfigurationSection configurationSection, ItemStack itemStack) {
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("nbt");
        if (configurationSection2 == null) {
            return itemStack;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        NbtTagLoader.loadNbt(nBTItem, null, configurationSection2);
        return nBTItem.getItem();
    }

    private static ItemStack loadSpawner(ConfigurationSection configurationSection, ItemStack itemStack) {
        EntityType entityType;
        if (!ItemUtils.isSpawner(itemStack)) {
            return itemStack;
        }
        String string = configurationSection.getString("mob");
        if (string == null) {
            return itemStack;
        }
        try {
            entityType = EntityType.valueOf((String)string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidSpawnerEntityTypeException();
        }
        return ShopGuiPlugin.getInstance().getSpawnerManager().getSpawnerItem(entityType);
    }

    private static ItemStack loadItemMeta(ConfigurationSection configurationSection, ItemStack itemStack) {
        List list;
        String string;
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        List list2 = configurationSection.getStringList("lore");
        if (CollectionUtils.isNotEmpty(list2)) {
            itemMeta.setLore(ChatUtils.fixColors(list2));
        }
        if (StringUtils.isNotEmpty((String)(string = configurationSection.getString("name")))) {
            itemMeta.setDisplayName(ChatUtils.fixColors(string));
        }
        if (CollectionUtils.isNotEmpty(list = configurationSection.getStringList("flags"))) {
            ArrayList<ItemFlag> arrayList = new ArrayList<ItemFlag>();
            for (String string2 : list) {
                ItemFlag itemFlag = null;
                try {
                    itemFlag = ItemFlag.valueOf((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidItemFlagException();
                }
                arrayList.add(itemFlag);
            }
            itemMeta.addItemFlags(arrayList.toArray(new ItemFlag[0]));
        }
        if (configurationSection.getBoolean("unbreakable")) {
            ItemUtils.setUnbreakable(itemMeta);
        }
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_14) && configurationSection.isSet("model")) {
            int n;
            try {
                n = Integer.parseInt(configurationSection.getString("model"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidModelException();
            }
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static ItemStack loadItemGlow(ConfigurationSection configurationSection, ItemStack itemStack) {
        boolean bl = configurationSection.getBoolean("glow", false);
        if (!bl || !itemStack.getEnchantments().isEmpty()) {
            return itemStack;
        }
        Enchantment enchantment = itemStack.getType().name().contains("ROD") ? Enchantment.SILK_TOUCH : Enchantment.LURE;
        itemStack.addUnsafeEnchantment(enchantment, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static void setUnbreakable(ItemMeta itemMeta) {
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9)) {
            itemMeta.setUnbreakable(true);
        } else {
            try {
                Class<ItemMeta> clazz = ItemMeta.class;
                Method method = clazz.getDeclaredMethod("spigot", new Class[0]);
                method.setAccessible(true);
                Object object = method.invoke((Object)itemMeta, new Object[0]);
                Class<?> clazz2 = object.getClass();
                Method method2 = clazz2.getDeclaredMethod("setUnbreakable", Boolean.TYPE);
                method2.setAccessible(true);
                method2.invoke(object, true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                throw new ItemLoadException("Failed to set unbreakable tag on an item");
            }
        }
    }

    private static DyeColor getDyeColor(String string) {
        DyeColor dyeColor;
        try {
            dyeColor = DyeColor.valueOf((String)string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDyeColorException();
        }
        return dyeColor;
    }

    private static Color getFireworkColor(String string) {
        return ItemUtils.getDyeColor(string).getFireworkColor();
    }

    public static String formatItemName(ItemStack itemStack, Player player) {
        String string;
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        String string2 = string = ShopGuiPlugin.getInstance().enableLanguage() ? ShopGuiPlugin.getInstance().getLanguageProvider().getItemName(itemStack, player) : itemStack.getType().toString().toLowerCase().replace("_", " ");
        if (Settings.capitalizeItemNames) {
            string = WordUtils.capitalize((String)string);
        }
        return string;
    }

    public static boolean compareItemStacks(ItemStack itemStack, ItemStack itemStack2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        if (itemStack.getType() != itemStack2.getType() || bl3 && itemStack.getDurability() != itemStack2.getDurability()) {
            return false;
        }
        if (bl && !itemStack.getItemMeta().equals(itemStack2.getItemMeta())) {
            return false;
        }
        if (!ItemUtils.compareUnbreakable(itemStack, itemStack2)) {
            return false;
        }
        if (ItemUtils.isSpawner(itemStack) && ItemUtils.isSpawner(itemStack2) && ShopGuiPlugin.getInstance().getSpawnerManager().getEntityType(itemStack) != ShopGuiPlugin.getInstance().getSpawnerManager().getEntityType(itemStack2)) {
            return false;
        }
        if (ItemUtils.isPlayerHead(itemStack) && (!itemStack.hasItemMeta() || !itemStack2.hasItemMeta() || !ItemUtils.compareBase64Skins(itemStack, itemStack2) || ((SkullMeta)itemStack.getItemMeta()).hasOwner() && ((SkullMeta)itemStack2.getItemMeta()).hasOwner() && !((SkullMeta)itemStack.getItemMeta()).getOwner().equalsIgnoreCase(((SkullMeta)itemStack2.getItemMeta()).getOwner()))) {
            return false;
        }
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && (itemStack.getType() == Material.POTION || itemStack.getType() == Material.LINGERING_POTION || itemStack.getType() == Material.SPLASH_POTION) && !itemStack.getItemMeta().equals(itemStack2.getItemMeta())) {
            return false;
        }
        if (bl2 && NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_14) && !ItemUtils.compareCustomDataModel(itemStack, itemStack2)) {
            return false;
        }
        if (bl4 && !new NBTItem(itemStack).equals(new NBTItem(itemStack2))) {
            return false;
        }
        if (ShopGuiPlugin.getInstance().getItemManager().getCustomItemProvider(itemStack) != null && ShopGuiPlugin.getInstance().getItemManager().getCustomItemProvider(itemStack2) != null) {
            ItemProvider itemProvider;
            ItemProvider itemProvider2 = ShopGuiPlugin.getInstance().getItemManager().getCustomItemProvider(itemStack);
            return itemProvider2.equals(itemProvider = ShopGuiPlugin.getInstance().getItemManager().getCustomItemProvider(itemStack2)) && itemProvider2.compare(itemStack, itemStack2);
        }
        return true;
    }

    private static boolean compareBase64Skins(ItemStack itemStack, ItemStack itemStack2) {
        return NmsUtils.getHeadSkin(itemStack).equals(NmsUtils.getHeadSkin(itemStack2));
    }

    private static boolean compareCustomDataModel(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasCustomModelData() && (!itemStack2.hasItemMeta() || !itemStack2.getItemMeta().hasCustomModelData() || itemStack.getItemMeta().getCustomModelData() != itemStack2.getItemMeta().getCustomModelData())) {
            return false;
        }
        return !itemStack2.hasItemMeta() || !itemStack2.getItemMeta().hasCustomModelData() || itemStack.hasItemMeta() && itemStack.getItemMeta().hasCustomModelData() && itemStack.getItemMeta().getCustomModelData() == itemStack2.getItemMeta().getCustomModelData();
    }

    private static boolean compareUnbreakable(ItemStack itemStack, ItemStack itemStack2) {
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9)) {
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().isUnbreakable() && (!itemStack2.hasItemMeta() || !itemStack2.getItemMeta().isUnbreakable()) || itemStack2.hasItemMeta() && itemStack2.getItemMeta().isUnbreakable() && (!itemStack.hasItemMeta() || !itemStack.getItemMeta().isUnbreakable())) {
                return false;
            }
        } else {
            try {
                Method method;
                Class<?> clazz;
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                Class<ItemMeta> clazz2 = ItemMeta.class;
                Method method2 = clazz2.getDeclaredMethod("spigot", new Class[0]);
                method2.setAccessible(true);
                if (itemStack.hasItemMeta()) {
                    object = method2.invoke((Object)itemStack.getItemMeta(), new Object[0]);
                    clazz = object.getClass();
                    method = clazz.getDeclaredMethod("isUnbreakable", new Class[0]);
                    method.setAccessible(true);
                    bl = (Boolean)method.invoke(object, new Object[0]);
                }
                if (itemStack2.hasItemMeta()) {
                    object = method2.invoke((Object)itemStack2.getItemMeta(), new Object[0]);
                    clazz = object.getClass();
                    method = clazz.getDeclaredMethod("isUnbreakable", new Class[0]);
                    method.setAccessible(true);
                    bl2 = (Boolean)method.invoke(object, new Object[0]);
                }
                if (bl != bl2) {
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return true;
    }

    public static ItemStack stripItemMeta(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasDisplayName()) {
            itemMeta.setDisplayName("");
        }
        if (itemMeta.hasLore()) {
            itemMeta.setLore(new ArrayList());
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static boolean isSpawner(ItemStack itemStack) {
        return LegacyItemStackHandler.isSpawner(itemStack.getType());
    }

    public static boolean isFirework(ItemStack itemStack) {
        return LegacyItemStackHandler.isFirework(itemStack.getType());
    }

    public static boolean isFireworkStar(ItemStack itemStack) {
        return LegacyItemStackHandler.isFireworkStar(itemStack.getType());
    }

    public static boolean isBanner(ItemStack itemStack) {
        return LegacyItemStackHandler.isBanner(itemStack.getType());
    }

    public static boolean isPlayerHead(ItemStack itemStack) {
        return LegacyItemStackHandler.isPlayerHead(itemStack);
    }

    public static boolean isSpawnEgg(ItemStack itemStack) {
        return LegacyItemStackHandler.isSpawnEgg(itemStack.getType());
    }

    public static boolean isShield(ItemStack itemStack) {
        return itemStack.getType() == Material.SHIELD;
    }
}

