/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt;

import dev.hexedhero.pinprompt.commands.PINPromptCommand;
import dev.hexedhero.pinprompt.database.SQLiteConnector;
import dev.hexedhero.pinprompt.database.migrations._SPECIAL_Version2Migrator;
import dev.hexedhero.pinprompt.listeners.BlockEventsListener;
import dev.hexedhero.pinprompt.listeners.InventoryListener;
import dev.hexedhero.pinprompt.listeners.JoinAndLeaveListener;
import dev.hexedhero.pinprompt.managers.BanManager;
import dev.hexedhero.pinprompt.managers.DataManager;
import dev.hexedhero.pinprompt.managers.FlyManager;
import dev.hexedhero.pinprompt.managers.HeadStyleManager;
import dev.hexedhero.pinprompt.managers.InventoryManager;
import dev.hexedhero.pinprompt.managers.NMSManager;
import dev.hexedhero.pinprompt.managers.PINManager;
import dev.hexedhero.pinprompt.managers.SpectatorManager;
import dev.hexedhero.pinprompt.managers.TaskManager;
import dev.hexedhero.pinprompt.managers.TeleportManager;
import dev.hexedhero.pinprompt.shaded.bstats.bukkit.Metrics;
import dev.hexedhero.pinprompt.shaded.bstats.charts.SimplePie;
import dev.hexedhero.pinprompt.shaded.bstats.charts.SingleLineChart;
import dev.hexedhero.pinprompt.tasks.UpdateCheckerTask;
import dev.hexedhero.pinprompt.utils.Common;
import dev.hexedhero.pinprompt.utils.PluginInformation;
import dev.hexedhero.pinprompt.utils.RegistrationHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PINPrompt
extends JavaPlugin {
    private static PINPrompt instance;

    public static PINPrompt getInstance() {
        return instance;
    }

    public PINPrompt() {
        instance = this;
    }

    public void onEnable() {
        System.out.println("\u001b[36m[Spigotunlocked.com] - ZER.");
        PINPrompt.loadConfig0();
        long l = System.nanoTime();
        Common.tellConsole(true, "Initializing managers...");
        DataManager.getInstance();
        NMSManager.getInstance();
        TaskManager.getInstance();
        HeadStyleManager.getInstance();
        InventoryManager.getInstance();
        PINManager.getInstance();
        BanManager.getInstance();
        FlyManager.getInstance();
        SpectatorManager.getInstance();
        TeleportManager.getInstance();
        new _SPECIAL_Version2Migrator();
        Common.tellConsole(true, "Registering commands...");
        RegistrationHelper.registerCommands(new PINPromptCommand());
        Common.tellConsole(true, "Registering listeners...");
        RegistrationHelper.registerListeners(new JoinAndLeaveListener(), new InventoryListener(), new BlockEventsListener());
        Common.tellConsole(true, "Loading data...");
        this.saveDefaultConfig();
        Common.tellConsole(true, "Starting metrics...");
        Metrics metrics = new Metrics(PINPrompt.getInstance(), 8510);
        metrics.addCustomChart(new SimplePie("database_type", () -> DataManager.getInstance().getDatabaseConnector() instanceof SQLiteConnector ? "SQLite" : "MySQL"));
        metrics.addCustomChart(new SingleLineChart("players_with_pin", () -> DataManager.getInstance().getPlayerInformationRowAmount()));
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)PINPrompt.getInstance(), (Runnable)new UpdateCheckerTask(), 0L, 1728000L);
        Common.tellConsole(true, "&aPlugin registered to %plugin_purchaser% | %plugin_nonce%".replace("%plugin_purchaser%", PluginInformation.getPurchaser()).replace("%plugin_nonce%", PluginInformation.getNonce()));
        Common.tellConsole(true, "&aDone and enabled in %time%ms".replace("%time%", Common.nanosToMillis(System.nanoTime() - l)));
    }

    public void onDisable() {
        long l = System.nanoTime();
        Common.tellConsole(true, "Saving data...");
        DataManager.getInstance().saveAllPINPlayers(DataManager.getInstance().getAllPINPlayers(), true);
        Common.tellConsole(true, "Closing any database connections...");
        DataManager.getInstance().getDatabaseConnector().closeConnections();
        Common.tellConsole(true, "&aDone and disabled in %time%ms".replace("%time%", Common.nanosToMillis(System.nanoTime() - l)), "&aIf you liked the plugin, don't forget to give a &e\u2605\u2605\u2605\u2605\u2605 &arating!", "&aThank you and have a great day!");
    }

    public void reloadPlugin(CommandSender commandSender) {
        Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&aReloading &a&l%plugin_name%&a:".replace("%plugin_name%", PluginInformation.getName()));
        Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&7Reloading config...");
        this.reloadConfig();
        HeadStyleManager.getInstance().setupHeadStyleType(commandSender);
        InventoryManager.getInstance().stockInventory();
        Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&aReloaded &a&l%plugin_name% %plugin_version%&a successfully!".replace("%plugin_name%", PluginInformation.getName()).replace("%plugin_version%", "v" + PluginInformation.getVersion()));
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection uRLConnection = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=%%__NONCE__%%").openConnection();
            uRLConnection.setConnectTimeout(1000);
            uRLConnection.setReadTimeout(1000);
            ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
            String string = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream())).readLine();
            if ("false".equals(string)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

