/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.commands;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.enums.EPINOpenReason;
import dev.hexedhero.pinprompt.managers.BanManager;
import dev.hexedhero.pinprompt.managers.DataManager;
import dev.hexedhero.pinprompt.managers.InventoryManager;
import dev.hexedhero.pinprompt.objects.PINPlayer;
import dev.hexedhero.pinprompt.utils.Common;
import dev.hexedhero.pinprompt.utils.PluginInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PINPromptCommand
extends Command {
    public PINPromptCommand() {
        super("pinprompt");
        this.setAliases(Arrays.asList("pin", "pp", "pinp", "pprompt"));
        this.setDescription("Plugin main command");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(CommandSender commandSender, String string, String[] stringArray) {
        if (!(stringArray.length >= 1 && (stringArray[0].equalsIgnoreCase("create") || stringArray[0].equalsIgnoreCase("change") || stringArray[0].equalsIgnoreCase("reload") || stringArray[0].equalsIgnoreCase("lock") || stringArray[0].equalsIgnoreCase("remove") || stringArray[0].equalsIgnoreCase("unban") || stringArray[0].equalsIgnoreCase("help")))) {
            this.sendDefaultMessage(commandSender);
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("create")) {
            if (!commandSender.hasPermission("pinprompt.command.create")) {
                this.sendDefaultMessage(commandSender);
                return true;
            }
            if (!(commandSender instanceof Player)) {
                Common.tell(commandSender, Common.getLanguage("Player Only Command", commandSender instanceof Player));
                return true;
            }
            Player player = (Player)commandSender;
            UUID uUID = player.getUniqueId();
            if (DataManager.getInstance().getPINPlayer(uUID).getPIN() == null) {
                InventoryManager.getInstance().openNewPINInventory(player, EPINOpenReason.CREATION);
                return true;
            }
            Common.tell((CommandSender)player, Common.getLanguage("PIN Already Created", commandSender instanceof Player));
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("change")) {
            String string2;
            if (stringArray.length == 1) {
                if (!commandSender.hasPermission("pinprompt.command.change")) {
                    this.sendDefaultMessage(commandSender);
                    return true;
                }
                if (!(commandSender instanceof Player)) {
                    Common.tell(commandSender, Common.getLanguage("Player Only Command", commandSender instanceof Player));
                    return true;
                }
                Player player = (Player)commandSender;
                UUID uUID = player.getUniqueId();
                if (DataManager.getInstance().getPINPlayer(uUID).getPIN() != null) {
                    InventoryManager.getInstance().openNewPINInventory(player, EPINOpenReason.CREATION_CHANGE);
                    return true;
                }
                Common.tell((CommandSender)player, Common.getLanguage("No PIN Created", commandSender instanceof Player));
                return true;
            }
            if (stringArray.length == 3) {
                if (!commandSender.hasPermission("pinprompt.command.change.other")) {
                    this.sendDefaultMessage(commandSender);
                    return true;
                }
                string2 = stringArray[2];
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    Common.tell(commandSender, Common.getLanguage("Invalid Numbers", commandSender instanceof Player).replace("%amount%", Integer.toString(Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8))));
                    return true;
                }
                if (string2.length() != Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8) || string2.contains("0")) {
                    Common.tell(commandSender, Common.getLanguage("Invalid Numbers", commandSender instanceof Player).replace("%amount%", Integer.toString(Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8))));
                    return true;
                }
            } else {
                this.sendDefaultMessage(commandSender);
                return true;
            }
            Common.tell(commandSender, Common.getLanguage("Getting Player Information", commandSender instanceof Player));
            String string3 = stringArray[1];
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)PINPrompt.getInstance(), () -> {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string3);
                UUID uUID = offlinePlayer.getUniqueId();
                PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(uUID) != null ? DataManager.getInstance().getPINPlayer(uUID) : DataManager.getInstance().loadPINPlayer(uUID);
                pINPlayer.setPIN(string2);
                pINPlayer.setLastEnteredTime(null);
                pINPlayer.setLastEnteredIP(null);
                DataManager.getInstance().savePINPlayer(pINPlayer, !offlinePlayer.isOnline());
                Bukkit.getScheduler().runTask((Plugin)PINPrompt.getInstance(), () -> Common.tell(commandSender, Common.getLanguage("Set New PIN Other", commandSender instanceof Player).replace("%player%", offlinePlayer.getName()).replace("%newpin%", string2)));
            });
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("reload")) {
            if (!commandSender.hasPermission("pinprompt.command.reload")) {
                this.sendDefaultMessage(commandSender);
                return true;
            }
            PINPrompt.getInstance().reloadPlugin(commandSender);
            return true;
        } else {
            if (stringArray[0].equalsIgnoreCase("lock")) {
                if (!commandSender.hasPermission("pinprompt.command.lock")) {
                    this.sendDefaultMessage(commandSender);
                    return true;
                }
                if (!(commandSender instanceof Player)) {
                    Common.tell(commandSender, Common.getLanguage("Player Only Command", commandSender instanceof Player));
                    return true;
                }
                Player player = (Player)commandSender;
                UUID uUID = player.getUniqueId();
                PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(uUID);
                if (pINPlayer.getPIN() != null) {
                    InventoryManager.getInstance().openNewPINInventory(player, EPINOpenReason.LOCK);
                    pINPlayer.setLastEnteredTime(null);
                    pINPlayer.setLastEnteredIP(null);
                    return true;
                }
                Common.tell((CommandSender)player, Common.getLanguage("No PIN Created", commandSender instanceof Player));
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("remove")) {
                if (stringArray.length == 1) {
                    if (!commandSender.hasPermission("pinprompt.command.remove")) {
                        this.sendDefaultMessage(commandSender);
                        return true;
                    }
                    if (!(commandSender instanceof Player)) {
                        Common.tell(commandSender, Common.getLanguage("Player Only Command", commandSender instanceof Player));
                        return true;
                    }
                    Player player = (Player)commandSender;
                    UUID uUID = player.getUniqueId();
                    PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(uUID);
                    if (pINPlayer.getPIN() != null) {
                        Common.tell(commandSender, Common.getLanguage("Getting Player Information", commandSender instanceof Player));
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PINPrompt.getInstance(), () -> {
                            DataManager.getInstance().removePINPlayer(pINPlayer, false);
                            Bukkit.getScheduler().runTask((Plugin)PINPrompt.getInstance(), () -> Common.tell((CommandSender)player, Common.getLanguage("Removed PIN", commandSender instanceof Player)));
                        });
                        return true;
                    }
                    Common.tell((CommandSender)player, Common.getLanguage("No PIN Created", commandSender instanceof Player));
                    return true;
                }
                if (stringArray.length == 2) {
                    if (!commandSender.hasPermission("pinprompt.command.remove.other")) {
                        this.sendDefaultMessage(commandSender);
                        return true;
                    }
                } else {
                    this.sendDefaultMessage(commandSender);
                    return true;
                }
                Common.tell(commandSender, Common.getLanguage("Getting Player Information", commandSender instanceof Player));
                String string4 = stringArray[1];
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PINPrompt.getInstance(), () -> {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string4);
                    UUID uUID = offlinePlayer.getUniqueId();
                    PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(uUID) != null ? DataManager.getInstance().getPINPlayer(uUID) : DataManager.getInstance().loadPINPlayer(uUID);
                    DataManager.getInstance().removePINPlayer(pINPlayer, !offlinePlayer.isOnline());
                    Bukkit.getScheduler().runTask((Plugin)PINPrompt.getInstance(), () -> Common.tell(commandSender, Common.getLanguage("Removed PIN Other", commandSender instanceof Player).replace("%player%", offlinePlayer.getName())));
                });
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("unban")) {
                if (stringArray.length == 2) {
                    if (!commandSender.hasPermission("pinprompt.command.unban")) {
                        this.sendDefaultMessage(commandSender);
                        return true;
                    }
                    Common.tell(commandSender, Common.getLanguage("Getting Player Information", commandSender instanceof Player));
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)PINPrompt.getInstance(), () -> {
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[1]);
                        Bukkit.getScheduler().runTask((Plugin)PINPrompt.getInstance(), () -> {
                            if (!BanManager.getInstance().isUUIDBanned(offlinePlayer.getUniqueId())) {
                                Common.tell(commandSender, Common.getLanguage("Not Banned", commandSender instanceof Player).replace("%player%", offlinePlayer.getName()));
                                return;
                            }
                            BanManager.getInstance().unbanUUID(offlinePlayer.getUniqueId());
                            Common.tell(commandSender, Common.getLanguage("Unbanned Player", commandSender instanceof Player).replace("%player%", offlinePlayer.getName()));
                        });
                    });
                    return true;
                }
                this.sendDefaultMessage(commandSender);
                return true;
            }
            if (!stringArray[0].equalsIgnoreCase("help")) return true;
            if (!commandSender.hasPermission("pinprompt.command.help")) {
                this.sendDefaultMessage(commandSender);
                return true;
            }
            for (String string5 : Common.getLanguageList("Command Usage", commandSender instanceof Player)) {
                Common.tell(commandSender, string5);
            }
            return true;
        }
    }

    public List<String> tabComplete(CommandSender commandSender, String string2, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length == 1) {
            arrayList.add("create");
            arrayList.add("change");
            arrayList.add("reload");
            arrayList.add("lock");
            arrayList.add("remove");
            arrayList.add("unban");
            arrayList.add("help");
        } else if (stringArray[0].equalsIgnoreCase("change")) {
            if (stringArray.length == 2) {
                Bukkit.getOnlinePlayers().forEach(player -> arrayList.add(player.getName()));
            } else if (stringArray.length == 3) {
                arrayList.add("(PIN)");
            }
        } else if (stringArray[0].equalsIgnoreCase("unban") && stringArray.length == 2) {
            Bukkit.getOnlinePlayers().forEach(player -> arrayList.add(player.getName()));
        }
        return stringArray[stringArray.length - 1].isEmpty() ? arrayList : arrayList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[stringArray.length - 1].toLowerCase())).collect(Collectors.toList());
    }

    private void sendDefaultMessage(CommandSender commandSender) {
        Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&a&lPINPrompt %version%&a licensed to &a&l%purchaser%".replace("%version%", PluginInformation.getVersion()).replace("%purchaser%", PluginInformation.getPurchaser()), Common.getLanguagePrefix(commandSender) + "&aFor command help see &a&l/PINPrompt Help");
    }
}

