/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.database;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.database.IDatabaseConnector;
import dev.hexedhero.pinprompt.shaded.hikari.HikariConfig;
import dev.hexedhero.pinprompt.shaded.hikari.HikariDataSource;
import dev.hexedhero.pinprompt.utils.Common;
import java.sql.Connection;
import java.sql.SQLException;

public class MySQLConnector
implements IDatabaseConnector {
    private final HikariDataSource hikari;

    public MySQLConnector() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl("jdbc:mysql://%ip%:%port%/%database%?allowPublicKeyRetrieval=true&useSSL=%ssl%".replace("%ip%", PINPrompt.getInstance().getConfig().getString("Database.IP")).replace("%port%", PINPrompt.getInstance().getConfig().getString("Database.Port")).replace("%database%", PINPrompt.getInstance().getConfig().getString("Database.Database")).replace("%ssl%", Boolean.toString(PINPrompt.getInstance().getConfig().getBoolean("Database.SSL"))));
        hikariConfig.setUsername(PINPrompt.getInstance().getConfig().getString("Database.Username"));
        hikariConfig.setPassword(PINPrompt.getInstance().getConfig().getString("Database.Password"));
        hikariConfig.setConnectionTimeout((long)(PINPrompt.getInstance().getConfig().getDouble("Database.Connection Timeout") * 1000.0));
        hikariConfig.setMaximumPoolSize(PINPrompt.getInstance().getConfig().getInt("Database.Maximum Pool Size"));
        this.hikari = new HikariDataSource(hikariConfig);
    }

    @Override
    public void closeConnections() {
        this.hikari.close();
    }

    @Override
    public Connection getConnection() {
        try {
            return this.hikari.getConnection();
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR GETTING CONNECTION TO DATABASE");
            sQLException.printStackTrace();
            return null;
        }
    }
}

