/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.listeners;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.managers.InventoryManager;
import dev.hexedhero.pinprompt.managers.NMSManager;
import dev.hexedhero.pinprompt.managers.PINManager;
import dev.hexedhero.pinprompt.utils.ColorHelper;
import dev.hexedhero.pinprompt.utils.Common;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class InventoryListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void a(InventoryClickEvent inventoryClickEvent) {
        Inventory inventory = inventoryClickEvent.getClickedInventory();
        if (inventory != null && InventoryManager.getInstance().getPINInventory().equals(inventory)) {
            inventoryClickEvent.setCancelled(true);
            int n = inventoryClickEvent.getSlot() + 1;
            if (n < 1 || n > 9) {
                return;
            }
            ClickType clickType = inventoryClickEvent.getClick();
            if (!clickType.equals((Object)ClickType.LEFT)) {
                return;
            }
            Player player = (Player)inventoryClickEvent.getWhoClicked();
            UUID uUID = player.getUniqueId();
            Common.playSound(player, player.getLocation(), Common.getSound("PIN Click"));
            if (PINManager.getInstance().addPINNumber(player, Integer.toString(n))) {
                return;
            }
            String string = PINManager.getInstance().getPlayersEnteredPIN(uUID);
            if (string.trim().isEmpty()) {
                NMSManager.getInstance().getNMSImplementation().updateGUITitle(player, ColorHelper.colorize(Common.getLanguage("PIN Name", false)));
                return;
            }
            boolean bl = PINPrompt.getInstance().getConfig().getBoolean("PIN Inventory.Hide Entered PIN Numbers");
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = string.split("");
            for (int i = 0; i < Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8); ++i) {
                stringBuilder.append(Common.getLanguage("PIN Progress Name", false).replace("%number%", stringArray.length > i ? (bl ? "*" : stringArray[i]) : " "));
            }
            NMSManager.getInstance().getNMSImplementation().updateGUITitle(player, ColorHelper.colorize(stringBuilder.toString()));
        }
    }
}

