/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.utils.Common;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BanManager {
    private final Set<UUID> bannedPlayers = new HashSet<UUID>(4);
    private final Map<UUID, BukkitTask> unbanTasks = new HashMap<UUID, BukkitTask>(4);
    private static BanManager instance;

    public static BanManager getInstance() {
        if (instance == null) {
            instance = new BanManager();
        }
        return instance;
    }

    private BanManager() {
        Common.tellConsole(true, "BanManager initialized!");
    }

    public boolean isUUIDBanned(UUID uUID) {
        return this.bannedPlayers.contains(uUID);
    }

    public void banUUID(UUID uUID, double d) {
        Common.debugToConsole("Ban list", "Banning %uuid%".replace("%uuid%", uUID.toString()));
        this.bannedPlayers.add(uUID);
        if (d != -1.0) {
            BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)PINPrompt.getInstance(), () -> this.bannedPlayers.remove(uUID), (long)d);
            this.unbanTasks.put(uUID, bukkitTask);
        }
    }

    public boolean unbanUUID(UUID uUID) {
        if (this.isUUIDBanned(uUID)) {
            Common.debugToConsole("Ban list", "Unbanning %uuid%".replace("%uuid%", uUID.toString()));
            this.bannedPlayers.remove(uUID);
            if (this.unbanTasks.containsKey(uUID)) {
                this.unbanTasks.get(uUID).cancel();
                this.unbanTasks.remove(uUID);
            }
            return true;
        }
        return false;
    }
}

