/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.database.IDatabaseConnector;
import dev.hexedhero.pinprompt.database.MySQLConnector;
import dev.hexedhero.pinprompt.database.SQLiteConnector;
import dev.hexedhero.pinprompt.database.migrations.ADataRevision;
import dev.hexedhero.pinprompt.database.migrations._1_Init;
import dev.hexedhero.pinprompt.objects.PINPlayer;
import dev.hexedhero.pinprompt.utils.Common;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class DataManager {
    private static final List<ADataRevision> DATABASE_REVISIONS = Arrays.asList(new _1_Init());
    private final Set<PINPlayer> playerData = new HashSet<PINPlayer>(Math.max(4, Math.min(64, Bukkit.getServer().getMaxPlayers())));
    private final IDatabaseConnector databaseConnector;
    private static DataManager instance;

    public static DataManager getInstance() {
        if (instance == null) {
            instance = new DataManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataManager() {
        switch (PINPrompt.getInstance().getConfig().getString("Database.Type").toUpperCase()) {
            case "SQLITE": {
                Common.tellConsole(true, "Using SQLite...");
                this.databaseConnector = new SQLiteConnector();
                break;
            }
            case "MYSQL": {
                Common.tellConsole(true, "Using MySQL...");
                this.databaseConnector = new MySQLConnector();
                break;
            }
            default: {
                Common.tellConsole(true, "&cInvalid database type in config.yml!");
                Common.tellConsole(true, "&cFalling back to SQLite...");
                this.databaseConnector = new SQLiteConnector();
            }
        }
        Object object = null;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        int n = this.getCurrentRevision();
        object = this.getDatabaseConnector().getConnection();
        for (ADataRevision aDataRevision : DATABASE_REVISIONS) {
            if (n >= aDataRevision.getID()) continue;
            try {
                aDataRevision.processRevision((Connection)object);
            }
            catch (Exception exception) {
                Common.tellConsole(true, "&cCANCELLED DATABASE REVISIONS DUE TO AN ERROR!");
                exception.printStackTrace();
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    statement2.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                try {
                    object.close();
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                Common.tellConsole(true, "DataManager initialized!");
                return;
            }
            try {
                statement = object.createStatement();
                statement.execute("SELECT init_plugin_version FROM pinprompt_information LIMIT 1");
                resultSet = statement.getResultSet();
                resultSet.next();
                String string = resultSet.getString(1);
                statement.execute("DELETE FROM pinprompt_information");
                statement2 = object.prepareStatement("INSERT INTO pinprompt_information VALUES (?, ?)");
                statement2.setString(1, string);
                statement2.setInt(2, aDataRevision.getID());
                statement2.execute();
            }
            catch (SQLException sQLException) {
                Common.tellConsole(true, "&cERROR INCREASING REVISION IN THE DATABASE!");
                sQLException.printStackTrace();
            }
            Common.tellConsole(true, "Database revision #%id% was processed.".replace("%id%", Integer.toString(aDataRevision.getID())));
        }
        try {
            resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            statement2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Common.tellConsole(true, "DataManager initialized!");
        return;
        catch (Exception exception) {
            try {
                resultSet.close();
            }
            catch (Exception exception6) {
                // empty catch block
            }
            try {
                statement2.close();
            }
            catch (Exception exception7) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception8) {
                // empty catch block
            }
            try {
                object.close();
            }
            catch (Exception exception9) {
                // empty catch block
            }
            Common.tellConsole(true, "DataManager initialized!");
            return;
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (Exception exception10) {
                    // empty catch block
                }
                try {
                    statement2.close();
                }
                catch (Exception exception11) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception12) {
                    // empty catch block
                }
                try {
                    object.close();
                }
                catch (Exception exception13) {
                    // empty catch block
                }
                Common.tellConsole(true, "DataManager initialized!");
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getCurrentRevision() {
        int n = 0;
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        ResultSet resultSet2 = null;
        try {
            connection = this.getDatabaseConnector().getConnection();
            resultSet = connection.getMetaData().getTables(null, null, "pinprompt_information", null);
            if (!resultSet.next()) {
                int n2 = n;
                return n2;
            }
            statement = connection.createStatement();
            statement.execute("SELECT current_revision FROM pinprompt_information LIMIT 1");
            resultSet2 = statement.getResultSet();
            if (resultSet2 == null || !resultSet2.isBeforeFirst()) {
                int n3 = n;
                return n3;
            }
            resultSet2.next();
            n = resultSet2.getInt(1);
            return n;
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR CHECKING CURRENT REVISION IN DATABASE!");
            sQLException.printStackTrace();
            return n;
        }
        finally {
            try {
                resultSet2.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized PINPlayer loadPINPlayer(UUID uUID) {
        Common.debugToConsole("Database", "Loading PINPlayer for %uuid%".replace("%uuid%", uUID.toString()));
        String string = null;
        Long l = null;
        String string2 = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDatabaseConnector().getConnection();
            preparedStatement = connection.prepareStatement("SELECT * FROM pinprompt_player_information WHERE uuid = ?");
            preparedStatement.setString(1, uUID.toString());
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (resultSet != null && resultSet.isBeforeFirst()) {
                resultSet.next();
                string = resultSet.getString("pin");
                l = resultSet.getLong("last_entered_time");
                string2 = resultSet.getString("last_entered_ip");
            }
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR GETTING PLAYER INFORMATION FROM THE DATABASE!");
            sQLException.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        PINPlayer pINPlayer = new PINPlayer(uUID, string, l, string2);
        this.loadPlayerData(pINPlayer);
        return pINPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void savePINPlayer(PINPlayer pINPlayer, boolean bl) {
        Common.debugToConsole("Database", "Saving PINPlayer: %pinplayer%".replace("%pinplayer%", pINPlayer.toString()));
        Connection connection = null;
        Statement statement = null;
        try {
            if (pINPlayer.getPIN() != null) {
                connection = this.getDatabaseConnector().getConnection();
                statement = connection.prepareStatement("REPLACE INTO pinprompt_player_information VALUES (?, ?, ?, ?)");
                statement.setString(1, pINPlayer.getUUID().toString());
                statement.setString(2, pINPlayer.getPIN());
                statement.setString(3, pINPlayer.getLastEnteredTime() == null ? null : Long.toString(pINPlayer.getLastEnteredTime()));
                statement.setString(4, pINPlayer.getLastEnteredIP());
                statement.execute();
            }
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR SAVING PLAYER INFORMATION TO THE DATABASE!");
            sQLException.printStackTrace();
        }
        finally {
            if (bl) {
                this.unloadPlayerData(pINPlayer.getUUID());
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveAllPINPlayers(Set<PINPlayer> set, boolean bl) {
        if (set.isEmpty()) {
            return;
        }
        Common.debugToConsole("Database", "Saving PINPlayers: %pinplayers%".replace("%pinplayers%", set.stream().map(PINPlayer::toString).collect(Collectors.joining(", "))));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getDatabaseConnector().getConnection();
            statement = connection.prepareStatement("REPLACE INTO pinprompt_player_information VALUES (?, ?, ?, ?)");
            connection.setAutoCommit(false);
            for (PINPlayer pINPlayer : set) {
                if (pINPlayer.getPIN() == null) continue;
                statement.setString(1, pINPlayer.getUUID().toString());
                statement.setString(2, pINPlayer.getPIN());
                statement.setString(3, pINPlayer.getLastEnteredTime() == null ? null : Long.toString(pINPlayer.getLastEnteredTime()));
                statement.setString(4, pINPlayer.getLastEnteredIP());
                statement.addBatch();
            }
            statement.executeBatch();
            connection.commit();
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR SAVING ALL PLAYER INFORMATION TO THE DATABASE!");
            sQLException.printStackTrace();
        }
        finally {
            if (bl) {
                for (PINPlayer pINPlayer : new HashSet<PINPlayer>(set)) {
                    this.unloadPlayerData(pINPlayer.getUUID());
                }
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removePINPlayer(PINPlayer pINPlayer, boolean bl) {
        Common.debugToConsole("Database", "Removing PINPlayer: %pinplayer%".replace("%pinplayer%", pINPlayer.toString()));
        Connection connection = null;
        Statement statement = null;
        try {
            pINPlayer.setPIN(null);
            pINPlayer.setLastEnteredTime(null);
            pINPlayer.setLastEnteredIP(null);
            connection = this.getDatabaseConnector().getConnection();
            statement = connection.prepareStatement("DELETE FROM pinprompt_player_information WHERE uuid = ?");
            statement.setString(1, pINPlayer.getUUID().toString());
            statement.execute();
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR SAVING PLAYER INFORMATION TO THE DATABASE!");
            sQLException.printStackTrace();
        }
        finally {
            if (bl) {
                this.unloadPlayerData(pINPlayer.getUUID());
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void loadPlayerData(PINPlayer pINPlayer) {
        this.unloadPlayerData(pINPlayer.getUUID());
        Common.debugToConsole("Database", "Loading player data for %pinplayer%".replace("%pinplayer%", pINPlayer.toString()));
        this.playerData.add(pINPlayer);
    }

    public synchronized void unloadPlayerData(UUID uUID) {
        Common.debugToConsole("Database", "Unloading player data for %uuid%".replace("%uuid%", uUID.toString()));
        ArrayList<PINPlayer> arrayList = new ArrayList<PINPlayer>();
        for (PINPlayer pINPlayer : this.playerData) {
            if (!pINPlayer.getUUID().equals(uUID)) continue;
            arrayList.add(pINPlayer);
        }
        this.playerData.removeAll(arrayList);
    }

    public synchronized PINPlayer getPINPlayer(UUID uUID) {
        Common.debugToConsole("Database", "Getting PINPlayer for %uuid%, most likely getting some sort of data such as their PIN etc.".replace("%uuid%", uUID.toString()));
        for (PINPlayer pINPlayer : this.playerData) {
            if (!pINPlayer.getUUID().equals(uUID)) continue;
            return pINPlayer;
        }
        return this.loadPINPlayer(uUID);
    }

    public synchronized Set<PINPlayer> getAllPINPlayers() {
        Common.debugToConsole("Database", "Getting all PINPlayers: %pinplayers%".replace("%pinplayers%", this.playerData.stream().map(PINPlayer::toString).collect(Collectors.joining(", "))));
        return this.playerData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPlayerInformationRowAmount() {
        int n = 0;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDatabaseConnector().getConnection();
            preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM pinprompt_player_information");
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR GETTING ROW AMOUNT IN THE DATABASE!");
            sQLException.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public IDatabaseConnector getDatabaseConnector() {
        return this.databaseConnector;
    }
}

