/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import dev.hexedhero.pinprompt.utils.Common;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class TaskManager {
    private final HashMap<UUID, BukkitTask> timeoutTasks = new HashMap(4);
    private static TaskManager instance;

    public static TaskManager getInstance() {
        if (instance == null) {
            instance = new TaskManager();
        }
        return instance;
    }

    private TaskManager() {
        Common.tellConsole(true, "TaskManager initialized!");
    }

    public void putPlayerInTimeOutTask(Player player, BukkitTask bukkitTask) {
        this.timeoutTasks.put(player.getUniqueId(), bukkitTask);
    }

    public boolean cancelTimeOutTaskForPlayer(Player player) {
        BukkitTask bukkitTask = this.timeoutTasks.get(player.getUniqueId());
        if (bukkitTask != null) {
            Common.debugToConsole("Timeout task", "Cancelling task for %uuid%".replace("%uuid%", player.getUniqueId().toString()));
            bukkitTask.cancel();
            this.timeoutTasks.remove(player.getUniqueId());
            if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
                player.removePotionEffect(PotionEffectType.BLINDNESS);
            }
            return true;
        }
        return false;
    }
}

