/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customfishing.commands.AbstractSubCommand;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMainCommand
implements TabExecutor {
    protected final Map<String, AbstractSubCommand> subCommandMap = new ConcurrentHashMap<String, AbstractSubCommand>();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        List<String> argList = Arrays.asList(args);
        if (argList.size() < 1) {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.nonArgs);
            return true;
        }
        AbstractSubCommand subCommand = this.subCommandMap.get(argList.get(0));
        if (subCommand != null) {
            return subCommand.onCommand(sender, argList.subList(1, argList.size()));
        }
        AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.unavailableArgs);
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        List<String> argList = Arrays.asList(args);
        if (argList.size() <= 1) {
            ArrayList<String> returnList = new ArrayList<String>(this.subCommandMap.keySet());
            returnList.removeIf(str -> !str.startsWith(args[0]));
            return returnList;
        }
        AbstractSubCommand subCommand = this.subCommandMap.get(argList.get(0));
        if (subCommand != null) {
            return subCommand.onTabComplete(sender, argList.subList(1, argList.size()));
        }
        return Collections.singletonList("");
    }

    public void regSubCommand(AbstractSubCommand executor) {
        this.subCommandMap.put(executor.getSubCommand(), executor);
    }

    public Map<String, AbstractSubCommand> getSubCommandMap() {
        return this.subCommandMap;
    }
}

