/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.commands.subcmd;

import java.util.List;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.commands.AbstractSubCommand;
import net.momirealms.customfishing.integration.SeasonInterface;
import net.momirealms.customfishing.libs.net.momirealms.biomeapi.BiomeAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DebugCommand
extends AbstractSubCommand {
    public static final DebugCommand INSTANCE = new DebugCommand();

    public DebugCommand() {
        super("debug");
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        if (this.lackArgs(sender, 1, args.size()) || this.noConsoleExecute(sender)) {
            return true;
        }
        Player player = (Player)sender;
        switch (args.get(0)) {
            case "biome": {
                sender.sendMessage(BiomeAPI.getBiome(player.getLocation()));
                break;
            }
            case "time": {
                sender.sendMessage(String.valueOf(player.getWorld().getTime()));
                break;
            }
            case "world": {
                sender.sendMessage(player.getWorld().getName());
                break;
            }
            case "season": {
                SeasonInterface seasonInterface = CustomFishing.getInstance().getIntegrationManager().getSeasonInterface();
                if (seasonInterface == null) {
                    return true;
                }
                sender.sendMessage(seasonInterface.getSeason(player.getLocation().getWorld()));
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, List<String> args) {
        if (args.size() == 1) {
            return this.filterStartingWith(List.of("biome", "time", "world", "season"), args.get(0));
        }
        return null;
    }
}

