/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.action.Action;
import net.momirealms.customfishing.fishing.loot.Loot;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PlayerStatisticsData {
    private final ConcurrentHashMap<String, Integer> amountMap;
    private int total_catch_amount;

    public PlayerStatisticsData() {
        this.amountMap = new ConcurrentHashMap();
        this.total_catch_amount = 0;
    }

    public PlayerStatisticsData(ConfigurationSection section) {
        this.amountMap = new ConcurrentHashMap();
        this.total_catch_amount = 0;
        for (String key : section.getKeys(false)) {
            int amount = section.getInt(key);
            this.total_catch_amount += amount;
            this.amountMap.put(key, amount);
        }
    }

    public PlayerStatisticsData(String longText) {
        this.total_catch_amount = 0;
        this.amountMap = (ConcurrentHashMap)Arrays.stream(longText.split(";")).map(element -> element.split(":")).filter(pair -> ((String[])pair).length == 2).collect(Collectors.toConcurrentMap(pair -> pair[0], pair -> {
            int amount = Integer.parseInt(pair[1]);
            this.total_catch_amount += amount;
            return amount;
        }));
    }

    public String getLongText() {
        StringJoiner joiner = new StringJoiner(";");
        for (Map.Entry<String, Integer> entry : this.amountMap.entrySet()) {
            joiner.add(entry.getKey() + ":" + entry.getValue());
        }
        return joiner.toString();
    }

    public void addFishAmount(Loot loot, UUID uuid, int amount) {
        Integer previous = this.amountMap.get(loot.getKey());
        if (previous == null) {
            previous = 0;
        }
        int after = previous + amount;
        this.amountMap.put(loot.getKey(), after);
        this.total_catch_amount += amount;
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        this.doSuccessTimesAction(previous, after, player, loot);
    }

    private void doSuccessTimesAction(Integer previous, int after, Player player, Loot vanilla) {
        HashMap<Integer, Action[]> actionMap = vanilla.getSuccessTimesActions();
        if (actionMap != null) {
            for (Map.Entry<Integer, Action[]> entry : actionMap.entrySet()) {
                if (entry.getKey() <= previous || entry.getKey() > after) continue;
                for (Action action : entry.getValue()) {
                    action.doOn(player, null);
                }
            }
        }
    }

    public int getFishAmount(String key) {
        Integer amount = this.amountMap.get(key);
        return amount == null ? 0 : amount;
    }

    public boolean hasFished(String key) {
        return this.amountMap.containsKey(key);
    }

    public double getCategoryUnlockProgress(String category) {
        List<String> categories = CustomFishing.getInstance().getLootManager().getCategories(category);
        if (categories == null) {
            return -1.0;
        }
        double total = categories.size();
        double unlocked = 0.0;
        for (String value : categories) {
            if (!this.hasFished(value)) continue;
            unlocked += 1.0;
        }
        return unlocked / total * 100.0;
    }

    public int getCategoryTotalFishAmount(String category) {
        List<String> categories = CustomFishing.getInstance().getLootManager().getCategories(category);
        if (categories == null) {
            return -1;
        }
        int total = 0;
        for (String value : categories) {
            total += this.getFishAmount(value);
        }
        return total;
    }

    public void reset() {
        this.amountMap.clear();
    }

    public ConcurrentHashMap<String, Integer> getAmountMap() {
        return this.amountMap;
    }

    public void setData(String key, int value) {
        this.amountMap.put(key, value);
    }

    public int getTotalCatchAmount() {
        return this.total_catch_amount;
    }
}

