/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.bar;

import java.util.Objects;
import java.util.Set;
import net.momirealms.customfishing.fishing.bar.FishingBar;
import org.bukkit.configuration.ConfigurationSection;

public class ModeOneBar
extends FishingBar {
    private final int widthPerSection;
    private final double[] successRate;
    private final int totalWidth;
    private final int pointerWidth;
    private final String pointerImage;
    private final int pointerOffset;

    public ModeOneBar(ConfigurationSection section) {
        super(section);
        Set chances = Objects.requireNonNull(section.getConfigurationSection("success-rate-sections")).getKeys(false);
        this.widthPerSection = section.getInt("arguments.width-per-section", 16);
        this.successRate = new double[chances.size()];
        for (int i = 0; i < chances.size(); ++i) {
            this.successRate[i] = section.getDouble("success-rate-sections." + (i + 1));
        }
        this.totalWidth = chances.size() * this.widthPerSection - 1;
        this.pointerImage = section.getString("subtitle.pointer", "\ub004");
        this.pointerOffset = section.getInt("arguments.pointer-offset");
        this.pointerWidth = section.getInt("arguments.pointer-width");
    }

    public int getWidthPerSection() {
        return this.widthPerSection;
    }

    public double[] getSuccessRate() {
        return this.successRate;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public String getPointerImage() {
        return this.pointerImage;
    }

    public int getPointerWidth() {
        return this.pointerWidth;
    }

    public int getPointerOffset() {
        return this.pointerOffset;
    }
}

