/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.action.Action;
import net.momirealms.customfishing.fishing.competition.CompetitionConfig;
import net.momirealms.customfishing.fishing.competition.CompetitionGoal;
import net.momirealms.customfishing.fishing.competition.CompetitionPlayer;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarConfig;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarManager;
import net.momirealms.customfishing.fishing.competition.ranking.LocalRankingImpl;
import net.momirealms.customfishing.fishing.competition.ranking.RankingInterface;
import net.momirealms.customfishing.fishing.competition.ranking.RedisRankingImpl;
import net.momirealms.customfishing.integration.papi.PlaceholderManager;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.manager.MessageManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Competition {
    public static Competition currentCompetition;
    private final CompetitionConfig competitionConfig;
    private CompetitionGoal goal;
    private ScheduledFuture<?> timerTask;
    private RankingInterface ranking;
    private long startTime;
    private long remainingTime;
    private float progress;
    private BossBarManager bossBarManager;

    public Competition(CompetitionConfig competitionConfig) {
        this.competitionConfig = competitionConfig;
    }

    public void begin(boolean forceStart) {
        Collection playerCollections = Bukkit.getOnlinePlayers();
        if (playerCollections.size() >= this.competitionConfig.getMinPlayers() || forceStart) {
            BossBarConfig bossBarConfig;
            this.goal = this.competitionConfig.getGoal() == CompetitionGoal.RANDOM ? this.getRandomGoal() : this.competitionConfig.getGoal();
            this.remainingTime = this.competitionConfig.getDuration();
            this.startTime = Instant.now().getEpochSecond();
            this.ranking = ConfigManager.useRedis ? new RedisRankingImpl() : new LocalRankingImpl();
            this.ranking.clear();
            this.startTimer();
            PlaceholderManager placeholderManager = CustomFishing.getInstance().getIntegrationManager().getPlaceholderManager();
            for (String startMsg : this.competitionConfig.getStartMessage()) {
                for (Player player : playerCollections) {
                    AdventureUtils.playerMessage(player, placeholderManager.parse((OfflinePlayer)player, startMsg));
                }
            }
            for (String startCmd : this.competitionConfig.getStartCommand()) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), startCmd);
            }
            if (this.competitionConfig.isBossBarEnabled() && (bossBarConfig = this.competitionConfig.getBossBarConfig()) != null) {
                this.bossBarManager = new BossBarManager(bossBarConfig);
                this.bossBarManager.load();
                if (bossBarConfig.isShowToAll()) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        this.bossBarManager.tryJoin(player, false);
                    }
                }
            }
        } else {
            for (Player player : playerCollections) {
                AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.notEnoughPlayers);
            }
            currentCompetition = null;
        }
    }

    private void startTimer() {
        this.timerTask = CustomFishing.getInstance().getScheduler().runTaskTimer(() -> {
            if (this.decreaseTime()) {
                this.end();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void cancel() {
        if (this.bossBarManager != null) {
            this.bossBarManager.unload();
        }
        if (this.timerTask != null && !this.timerTask.isCancelled()) {
            this.timerTask.cancel(false);
        }
        this.ranking.clear();
        currentCompetition = null;
    }

    public void end() {
        if (this.bossBarManager != null) {
            this.bossBarManager.unload();
        }
        if (this.timerTask != null && !this.timerTask.isCancelled()) {
            this.timerTask.cancel(false);
        }
        this.givePrize();
        ArrayList<String> newMessage = new ArrayList<String>();
        PlaceholderManager placeholderManager = CustomFishing.getInstance().getIntegrationManager().getPlaceholderManager();
        for (String endMsg : this.competitionConfig.getEndMessage()) {
            ArrayList<String> placeholders = new ArrayList<String>(placeholderManager.detectBetterPlaceholders(endMsg));
            for (String placeholder : placeholders) {
                int rank;
                if (placeholder.endsWith("_player}")) {
                    rank = Integer.parseInt(placeholder.substring(1, placeholder.length() - 8));
                    endMsg = endMsg.replace(placeholder, Optional.ofNullable(this.ranking.getPlayerAt(rank)).orElse(MessageManager.noPlayer));
                    continue;
                }
                if (!placeholder.endsWith("_score}")) continue;
                rank = Integer.parseInt(placeholder.substring(1, placeholder.length() - 7));
                float score = this.ranking.getScoreAt(rank);
                endMsg = endMsg.replace(placeholder, score == 0.0f ? MessageManager.noScore : String.format("%.1f", Float.valueOf(score)));
            }
            newMessage.add(endMsg);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (String msg : newMessage) {
                AdventureUtils.playerMessage(player, placeholderManager.parse((OfflinePlayer)player, msg));
            }
        }
        for (String endCmd : this.competitionConfig.getEndCommand()) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), endCmd);
        }
        currentCompetition = null;
        CustomFishing.getInstance().getScheduler().runTaskAsyncLater(() -> this.ranking.clear(), 3L, TimeUnit.SECONDS);
    }

    public void givePrize() {
        HashMap<String, Action[]> rewardsMap = this.competitionConfig.getRewards();
        if (this.ranking.getSize() != 0 && rewardsMap != null) {
            Iterator<String> iterator = this.ranking.getIterator();
            int i = 1;
            while (iterator.hasNext()) {
                if (i < rewardsMap.size()) {
                    String playerName2 = iterator.next();
                    Player player = Bukkit.getPlayer((String)playerName2);
                    if (player != null) {
                        for (Action action : rewardsMap.get(String.valueOf(i))) {
                            action.doOn(player, null);
                        }
                    }
                    ++i;
                    continue;
                }
                Action[] actions = rewardsMap.get("participation");
                if (actions == null) break;
                iterator.forEachRemaining(playerName -> {
                    Player player = Bukkit.getPlayer((String)playerName);
                    if (player != null) {
                        for (Action action : actions) {
                            action.doOn(player, null);
                        }
                    }
                });
            }
        }
    }

    private boolean decreaseTime() {
        long current = Instant.now().getEpochSecond();
        int duration = this.competitionConfig.getDuration();
        this.progress = (float)this.remainingTime / (float)duration;
        this.remainingTime = (long)duration - (current - this.startTime);
        long tVac = current - this.startTime + 1L;
        if (tVac != (long)duration - this.remainingTime) {
            for (long i = (long)duration - this.remainingTime; i < tVac; ++i) {
                if (this.remainingTime <= 0L) {
                    return true;
                }
                --this.remainingTime;
            }
        }
        return false;
    }

    private CompetitionGoal getRandomGoal() {
        return CompetitionGoal.values()[new Random().nextInt(CompetitionGoal.values().length - 1)];
    }

    public static boolean hasCompetitionOn() {
        return currentCompetition != null;
    }

    public float getProgress() {
        return this.progress;
    }

    public CompetitionConfig getCompetitionConfig() {
        return this.competitionConfig;
    }

    public String getPlayerRank(OfflinePlayer player) {
        return Optional.ofNullable(this.ranking.getPlayerRank(player.getName())).orElse(MessageManager.noRank);
    }

    public long getRemainingTime() {
        return this.remainingTime;
    }

    public double getScore(OfflinePlayer player) {
        return Optional.ofNullable(this.ranking.getCompetitionPlayer(player.getName())).orElse(CompetitionPlayer.emptyPlayer).getScore();
    }

    public boolean isJoined(Player player) {
        return this.ranking.getCompetitionPlayer(player.getName()) != null;
    }

    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    public void tryJoinCompetition(Player player) {
        if (this.bossBarManager != null) {
            this.bossBarManager.tryJoin(player, true);
        }
    }

    public void refreshData(Player player, float score, boolean doubleScore) {
        if (this.goal == CompetitionGoal.CATCH_AMOUNT) {
            score = 1.0f;
        }
        if (this.goal == CompetitionGoal.MAX_SIZE) {
            if (score > this.ranking.getPlayerScore(player.getName())) {
                this.ranking.setData(player.getName(), score);
            }
            return;
        }
        this.ranking.refreshData(player.getName(), doubleScore ? 2.0f * score : score);
    }

    public CompetitionGoal getGoal() {
        return this.goal;
    }

    public RankingInterface getRanking() {
        return this.ranking;
    }

    public static Competition getCurrentCompetition() {
        return currentCompetition;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

