/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition;

import org.jetbrains.annotations.NotNull;

public class CompetitionPlayer
implements Comparable<CompetitionPlayer> {
    private long time;
    private final String player;
    private float score;
    public static CompetitionPlayer emptyPlayer = new CompetitionPlayer(null, 0.0f);

    public CompetitionPlayer(String player, float score) {
        this.player = player;
        this.score = score;
        this.time = System.currentTimeMillis();
    }

    public void addScore(float score) {
        this.score += score;
        this.time = System.currentTimeMillis();
    }

    public void setScore(float score) {
        this.score = score;
        this.time = System.currentTimeMillis();
    }

    public float getScore() {
        return this.score;
    }

    public String getPlayer() {
        return this.player;
    }

    @Override
    public int compareTo(@NotNull CompetitionPlayer competitionPlayer) {
        if (competitionPlayer.getScore() != this.score) {
            return competitionPlayer.getScore() > this.score ? 1 : -1;
        }
        return competitionPlayer.getScore() > (float)this.time ? 1 : -1;
    }

    public String toString() {
        return "CompetitionPlayer{time=" + this.time + ", player='" + this.player + "', score=" + this.score + "}";
    }
}

