/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition.bossbar;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.competition.Competition;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarConfig;
import net.momirealms.customfishing.fishing.competition.bossbar.BossBarSender;
import net.momirealms.customfishing.listener.JoinQuitListener;
import net.momirealms.customfishing.object.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BossBarManager
extends Function {
    private static final ConcurrentHashMap<UUID, BossBarSender> senderMap = new ConcurrentHashMap();
    private final JoinQuitListener joinQuitListener = new JoinQuitListener(this);
    private final BossBarConfig bossBarConfig;

    public BossBarManager(BossBarConfig bossBarConfig) {
        this.bossBarConfig = bossBarConfig;
    }

    @Override
    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)CustomFishing.getInstance());
    }

    @Override
    public void unload() {
        if (this.joinQuitListener != null) {
            HandlerList.unregisterAll((Listener)this.joinQuitListener);
        }
        for (BossBarSender bossBarSender : senderMap.values()) {
            bossBarSender.hide();
        }
        senderMap.clear();
    }

    @Override
    public void onQuit(Player player) {
        BossBarSender sender = senderMap.get(player.getUniqueId());
        if (sender != null) {
            if (sender.isVisible()) {
                sender.hide();
            }
            senderMap.remove(player.getUniqueId());
        }
    }

    @Override
    public void onJoin(Player player) {
        CustomFishing.getInstance().getScheduler().runTaskAsyncLater(() -> {
            boolean hasJoined;
            if (Competition.currentCompetition != null && ((hasJoined = Competition.currentCompetition.isJoined(player)) || this.bossBarConfig.isShowToAll()) && senderMap.get(player.getUniqueId()) == null) {
                BossBarSender sender = new BossBarSender(player, this.bossBarConfig);
                sender.setHasClaimedJoinReward(hasJoined);
                if (!sender.isVisible()) {
                    sender.show();
                }
                senderMap.put(player.getUniqueId(), sender);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    public void tryJoin(Player player, boolean hasJoinReward) {
        BossBarSender sender = senderMap.get(player.getUniqueId());
        if (sender == null) {
            sender = new BossBarSender(player, Competition.currentCompetition.getCompetitionConfig().getBossBarConfig());
            senderMap.put(player.getUniqueId(), sender);
        }
        if (!sender.isVisible()) {
            sender.show();
        }
        if (hasJoinReward && !sender.hasClaimedJoin()) {
            sender.setHasClaimedJoinReward(true);
            for (String joinCmd : Competition.currentCompetition.getCompetitionConfig().getJoinCommand()) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), joinCmd.replace("{player}", player.getName()));
            }
        }
    }
}

