/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.momirealms.customfishing.fishing.competition.CompetitionPlayer;
import net.momirealms.customfishing.fishing.competition.ranking.RankingInterface;

public class LocalRankingImpl
implements RankingInterface {
    private final Set<CompetitionPlayer> competitionPlayers = Collections.synchronizedSet(new TreeSet());

    public void addPlayer(CompetitionPlayer competitionPlayer) {
        this.competitionPlayers.add(competitionPlayer);
    }

    public void removePlayer(CompetitionPlayer competitionPlayer) {
        this.competitionPlayers.removeIf(e -> e == competitionPlayer);
    }

    @Override
    public void clear() {
        this.competitionPlayers.clear();
    }

    @Override
    public CompetitionPlayer getCompetitionPlayer(String player) {
        for (CompetitionPlayer competitionPlayer : this.competitionPlayers) {
            if (!competitionPlayer.getPlayer().equals(player)) continue;
            return competitionPlayer;
        }
        return null;
    }

    @Override
    public Iterator<String> getIterator() {
        ArrayList<String> players = new ArrayList<String>();
        for (CompetitionPlayer competitionPlayer : this.competitionPlayers) {
            players.add(competitionPlayer.getPlayer());
        }
        return players.iterator();
    }

    @Override
    public int getSize() {
        return this.competitionPlayers.size();
    }

    @Override
    public String getPlayerRank(String player) {
        int index = 1;
        for (CompetitionPlayer competitionPlayer : this.competitionPlayers) {
            if (competitionPlayer.getPlayer().equals(player)) {
                return String.valueOf(index);
            }
            ++index;
        }
        return null;
    }

    @Override
    public float getPlayerScore(String player) {
        for (CompetitionPlayer competitionPlayer : this.competitionPlayers) {
            if (!competitionPlayer.getPlayer().equals(player)) continue;
            return competitionPlayer.getScore();
        }
        return 0.0f;
    }

    @Override
    public String getPlayerAt(int i) {
        int index = 1;
        for (CompetitionPlayer competitionPlayer : this.competitionPlayers) {
            if (index == i) {
                return competitionPlayer.getPlayer();
            }
            ++index;
        }
        return null;
    }

    @Override
    public float getScoreAt(int i) {
        int index = 1;
        for (CompetitionPlayer competitionPlayer : this.competitionPlayers) {
            if (index == i) {
                return competitionPlayer.getScore();
            }
            ++index;
        }
        return 0.0f;
    }

    @Override
    public void refreshData(String player, float score) {
        CompetitionPlayer competitionPlayer = this.getCompetitionPlayer(player);
        if (competitionPlayer != null) {
            this.removePlayer(competitionPlayer);
            competitionPlayer.addScore(score);
            this.addPlayer(competitionPlayer);
        } else {
            competitionPlayer = new CompetitionPlayer(player, score);
            this.addPlayer(competitionPlayer);
        }
    }

    @Override
    public void setData(String player, float score) {
        CompetitionPlayer competitionPlayer = this.getCompetitionPlayer(player);
        if (competitionPlayer != null) {
            this.removePlayer(competitionPlayer);
            competitionPlayer.setScore(score);
            this.addPlayer(competitionPlayer);
        } else {
            competitionPlayer = new CompetitionPlayer(player, score);
            this.addPlayer(competitionPlayer);
        }
    }
}

