/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.competition.ranking;

import java.util.Iterator;
import java.util.List;
import net.momirealms.customfishing.fishing.competition.CompetitionPlayer;
import net.momirealms.customfishing.fishing.competition.ranking.RankingInterface;
import net.momirealms.customfishing.util.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.resps.Tuple;

public class RedisRankingImpl
implements RankingInterface {
    @Override
    public void clear() {
        Jedis jedis = JedisUtils.getJedis();
        jedis.zremrangeByRank("cf_competition", 0L, -1L);
        jedis.close();
    }

    @Override
    public CompetitionPlayer getCompetitionPlayer(String player) {
        Jedis jedis = JedisUtils.getJedis();
        Double score = jedis.zscore("cf_competition", player);
        jedis.close();
        if (score == null || score == 0.0) {
            return null;
        }
        return new CompetitionPlayer(player, Float.parseFloat(score.toString()));
    }

    @Override
    public Iterator<String> getIterator() {
        Jedis jedis = JedisUtils.getJedis();
        List players = jedis.zrevrange("cf_competition", 0L, -1L);
        jedis.close();
        return players.iterator();
    }

    @Override
    public int getSize() {
        Jedis jedis = JedisUtils.getJedis();
        long size = jedis.zcard("cf_competition");
        jedis.close();
        return (int)size;
    }

    @Override
    public String getPlayerRank(String player) {
        Jedis jedis = JedisUtils.getJedis();
        Long rank = jedis.zrevrank("cf_competition", player);
        jedis.close();
        if (rank == null) {
            return null;
        }
        return String.valueOf(rank + 1L);
    }

    @Override
    public float getPlayerScore(String player) {
        Jedis jedis = JedisUtils.getJedis();
        Double rank = jedis.zscore("cf_competition", player);
        jedis.close();
        if (rank == null) {
            return 0.0f;
        }
        return rank.floatValue();
    }

    @Override
    public void refreshData(String player, float score) {
        Jedis jedis = JedisUtils.getJedis();
        jedis.zincrby("cf_competition", (double)score, player);
        jedis.close();
    }

    @Override
    public void setData(String player, float score) {
        Jedis jedis = JedisUtils.getJedis();
        jedis.zadd("cf_competition", (double)score, player);
        jedis.close();
    }

    @Override
    public String getPlayerAt(int rank) {
        Jedis jedis = JedisUtils.getJedis();
        List player = jedis.zrevrange("cf_competition", (long)(rank - 1), (long)(rank - 1));
        jedis.close();
        if (player == null) {
            return null;
        }
        if (player.size() == 0) {
            return null;
        }
        return (String)player.get(0);
    }

    @Override
    public float getScoreAt(int rank) {
        Jedis jedis = JedisUtils.getJedis();
        List players = jedis.zrevrangeWithScores("cf_competition", (long)(rank - 1), (long)(rank - 1));
        jedis.close();
        if (players == null) {
            return 0.0f;
        }
        if (players.size() == 0) {
            return 0.0f;
        }
        return (float)((Tuple)players.get(0)).getScore();
    }
}

