/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.fishing.mode;

import java.util.concurrent.TimeUnit;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.fishing.bar.ModeOneBar;
import net.momirealms.customfishing.fishing.mode.FishingGame;
import net.momirealms.customfishing.manager.FishingManager;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.entity.Player;

public class ModeOneGame
extends FishingGame {
    private int progress;
    private boolean face = true;
    private final ModeOneBar modeOneBar;

    public ModeOneGame(CustomFishing plugin, FishingManager fishingManager, long deadline, Player player, int difficulty, ModeOneBar modeOneBar) {
        super(plugin, fishingManager, deadline, player, difficulty, modeOneBar);
        this.modeOneBar = modeOneBar;
        this.gameTask = plugin.getScheduler().runTaskTimer(this, 50L, 54L - (long)difficulty * 4L, TimeUnit.MILLISECONDS);
        this.progress = -1;
    }

    @Override
    public void run() {
        super.run();
        this.progress = this.face ? ++this.progress : --this.progress;
        if (this.progress > this.modeOneBar.getTotalWidth()) {
            this.face = !this.face;
            this.progress = 2 * this.modeOneBar.getTotalWidth() - this.progress;
        } else if (this.progress < 0) {
            this.face = !this.face;
            this.progress = -this.progress;
        }
        this.showBar();
    }

    @Override
    public void showBar() {
        String bar = "<font:" + this.modeOneBar.getFont() + ">" + this.modeOneBar.getBarImage() + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars(this.modeOneBar.getPointerOffset() + this.progress) + "</font>" + this.modeOneBar.getPointerImage() + "<font:" + this.offsetManager.getFont() + ">" + this.offsetManager.getOffsetChars(this.modeOneBar.getTotalWidth() - this.progress - this.modeOneBar.getPointerWidth()) + "</font></font>";
        AdventureUtils.playerTitle(this.player, this.title, bar, 0, 500, 0);
    }

    @Override
    public boolean isSuccess() {
        int last = this.progress / this.modeOneBar.getWidthPerSection();
        return Math.random() < this.modeOneBar.getSuccessRate()[last];
    }
}

