/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.helper;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.helper.Log;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.utils.MinecraftVersion;
import net.momirealms.customfishing.libs.de.tr7zw.changeme.nbtapi.utils.VersionChecker;
import net.momirealms.customfishing.manager.ConfigManager;
import net.momirealms.customfishing.util.AdventureUtils;

public class VersionHelper {
    private boolean isNewerThan1_19_R2;
    private String serverVersion;
    private final CustomFishing plugin;
    private final boolean isSpigot;
    private final boolean isFolia;
    private final String pluginVersion;

    public VersionHelper(CustomFishing plugin) {
        this.plugin = plugin;
        this.isVersionNewerThan1_19_R2();
        this.disableUseLessInfo();
        String server_name = plugin.getServer().getName();
        this.isSpigot = server_name.equals("CraftBukkit");
        this.isFolia = server_name.equals("DirtyFolia");
        this.pluginVersion = plugin.getDescription().getVersion();
    }

    public boolean isVersionNewerThan1_19_R2() {
        if (this.serverVersion == null) {
            this.serverVersion = this.plugin.getServer().getClass().getPackage().getName().split("\\.")[3];
            String[] split = this.serverVersion.split("_");
            int main_ver = Integer.parseInt(split[1]);
            this.isNewerThan1_19_R2 = main_ver >= 20 ? true : (main_ver == 19 ? Integer.parseInt(split[2].substring(1)) >= 2 : false);
        }
        return this.isNewerThan1_19_R2;
    }

    private void disableUseLessInfo() {
        boolean hasGsonSupport;
        MinecraftVersion.disableBStats();
        MinecraftVersion.disableUpdateCheck();
        VersionChecker.hideOk = true;
        try {
            MinecraftVersion minecraftVersion;
            Field field = MinecraftVersion.class.getDeclaredField("version");
            field.setAccessible(true);
            try {
                minecraftVersion = MinecraftVersion.valueOf(this.serverVersion.replace("v", "MC"));
            }
            catch (IllegalArgumentException ex) {
                minecraftVersion = MinecraftVersion.UNKNOWN;
            }
            field.set(MinecraftVersion.class, (Object)minecraftVersion);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            Class.forName("com.google.gson.Gson");
            hasGsonSupport = true;
        }
        catch (Exception ex) {
            hasGsonSupport = false;
        }
        try {
            Field field = MinecraftVersion.class.getDeclaredField("hasGsonSupport");
            field.setAccessible(true);
            field.set(Boolean.class, hasGsonSupport);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkUpdate() {
        this.plugin.getScheduler().runTaskAsync(() -> {
            try {
                URL url = new URL("https://api.polymart.org/v1/getResourceInfoSimple/?resource_id=2723&key=version");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(60000);
                InputStream inputStream = conn.getInputStream();
                String newest = new BufferedReader(new InputStreamReader(inputStream)).readLine();
                String current = this.plugin.getDescription().getVersion();
                inputStream.close();
                if (!this.compareVer(newest, current)) {
                    AdventureUtils.consoleMessage(ConfigManager.lang.equalsIgnoreCase("chinese") ? "[CustomFishing] \u5f53\u524d\u5df2\u662f\u6700\u65b0\u7248\u672c" : "[CustomFishing] You are using the latest version.");
                    return;
                }
                if (ConfigManager.lang.equalsIgnoreCase("chinese")) {
                    AdventureUtils.consoleMessage("[CustomFishing] \u5f53\u524d\u7248\u672c: <red>" + current);
                    AdventureUtils.consoleMessage("[CustomFishing] \u6700\u65b0\u7248\u672c: <green>" + newest);
                    AdventureUtils.consoleMessage("[CustomFishing] \u8bf7\u5230 <u>\u552e\u540e\u7fa4<!u> \u6216 <u>https://polymart.org/resource/customfishing.2723<!u> \u83b7\u53d6\u6700\u65b0\u7248\u672c.");
                } else {
                    AdventureUtils.consoleMessage("[CustomFishing] Current version: <red>" + current);
                    AdventureUtils.consoleMessage("[CustomFishing] Latest version: <green>" + newest);
                    AdventureUtils.consoleMessage("[CustomFishing] Update is available: <u>https://polymart.org/resource/customfishing.2723<!u>");
                }
            }
            catch (Exception exception) {
                Log.warn("Error occurred when checking update");
            }
        });
    }

    private boolean compareVer(String newV, String currentV) {
        if (newV == null || currentV == null || newV.isEmpty() || currentV.isEmpty()) {
            return false;
        }
        String[] newVS = newV.split("\\.");
        String[] currentVS = currentV.split("\\.");
        int maxL = Math.min(newVS.length, currentVS.length);
        for (int i = 0; i < maxL; ++i) {
            try {
                String[] newPart = newVS[i].split("-");
                String[] currentPart = currentVS[i].split("-");
                int newNum = Integer.parseInt(newPart[0]);
                int currentNum = Integer.parseInt(currentPart[0]);
                if (newNum > currentNum) {
                    return true;
                }
                if (newNum < currentNum) {
                    return false;
                }
                if (newPart.length > 1 && currentPart.length > 1) {
                    int currentHotfixNum;
                    String[] newHotfix = newPart[1].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                    String[] currentHotfix = currentPart[1].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                    if (newHotfix.length == 2 && currentHotfix.length == 1) {
                        return true;
                    }
                    if (newHotfix.length <= 1 || currentHotfix.length <= 1) continue;
                    int newHotfixNum = Integer.parseInt(newHotfix[1]);
                    if (newHotfixNum > (currentHotfixNum = Integer.parseInt(currentHotfix[1]))) {
                        return true;
                    }
                    if (newHotfixNum < currentHotfixNum) {
                        return false;
                    }
                    return newHotfix[0].compareTo(currentHotfix[0]) > 0;
                }
                if (newPart.length > 1) {
                    return true;
                }
                if (currentPart.length <= 1) continue;
                return false;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }
        return newVS.length > currentVS.length;
    }

    public boolean isSpigot() {
        return this.isSpigot;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public boolean isFolia() {
        return this.isFolia;
    }
}

