/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.block;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import net.momirealms.customfishing.CustomFishing;
import net.momirealms.customfishing.integration.BlockInterface;
import net.momirealms.customfishing.util.AdventureUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class OraxenBlockImpl
implements BlockInterface {
    @Override
    public void removeBlock(Block block) {
        block.setType(Material.AIR);
    }

    @Override
    public void placeBlock(String id, Location location) {
        String blockID = CustomFishing.getInstance().getTotemManager().getInvertedBlock(id);
        if (blockID == null) {
            AdventureUtils.consoleMessage(id + " does not exist in default.yml");
            return;
        }
        if (BlockInterface.isVanillaItem(blockID)) {
            BlockInterface.placeVanillaBlock(blockID, location);
        } else {
            NoteBlockMechanicFactory.setBlockModel((Block)location.getBlock(), (String)blockID);
        }
    }

    @Override
    public void replaceBlock(Location location, String id) {
        this.placeBlock(id, location);
    }

    @Override
    @Nullable
    public String getID(Block block) {
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic((Block)block);
        String id = mechanic == null ? block.getType().name() : mechanic.getItemID();
        return CustomFishing.getInstance().getTotemManager().getBlockID(id);
    }
}

