/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customfishing.integration.job;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.ActionInfo;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.BaseActionInfo;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.listeners.JobsPaymentListener;
import java.util.List;
import net.momirealms.customfishing.api.event.FishResultEvent;
import net.momirealms.customfishing.fishing.FishResult;
import net.momirealms.customfishing.integration.JobInterface;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class JobsRebornImpl
implements JobInterface,
Listener {
    @Override
    public void addXp(Player player, double amount) {
        JobsPlayer jobsPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jobsPlayer != null) {
            List jobs = jobsPlayer.getJobProgression();
            Job job = Jobs.getJob((String)"Fisherman");
            for (JobProgression progression : jobs) {
                if (!progression.getJob().equals((Object)job)) continue;
                progression.addExperience(amount);
            }
        }
    }

    @Override
    public int getLevel(Player player) {
        JobsPlayer jobsPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jobsPlayer != null) {
            List jobs = jobsPlayer.getJobProgression();
            Job job = Jobs.getJob((String)"Fisherman");
            for (JobProgression progression : jobs) {
                if (!progression.getJob().equals((Object)job)) continue;
                return progression.getLevel();
            }
        }
        return 0;
    }

    @EventHandler
    public void onFish(FishResultEvent event) {
        if (event.isCancelled() || event.getResult() == FishResult.FAILURE) {
            return;
        }
        Player player = event.getPlayer();
        if (!Jobs.getGCManager().canPerformActionInWorld(player.getWorld())) {
            return;
        }
        if (!JobsPaymentListener.payIfCreative((Player)player)) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jobsPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jobsPlayer == null) {
            return;
        }
        Jobs.action((JobsPlayer)jobsPlayer, (ActionInfo)new CustomFishingInfo(event.getLootID(), ActionType.MMKILL));
    }

    public static class CustomFishingInfo
    extends BaseActionInfo {
        private final String name;

        public CustomFishingInfo(String name, ActionType type) {
            super(type);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNameWithSub() {
            return this.name;
        }
    }
}

